package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;

public class SimplyDoListTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
	private Solo solo;

	public SimplyDoListTest() {
		super(SimplyDoActivity.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() {
		// Attende il lancio dell'activity:
		// 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Aggiunta di un elenco
		Timeout.setSmallTimeout(28018);
		// Click nella casella del nome
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Inserimento del testo: 'list test 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"list test 1");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Aggiunta di un elenco già esistente
		Timeout.setSmallTimeout(28018);
		// Click nella casella del nome
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Inserimento del testo: 'list test 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"list test 1");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Aggiunta elenco avente nome vuoto
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Aggiunta elenco il cui nome ha spazi multipli al centro, inizio e
		// fine
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Nome: ' nome con spazi '
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"   nome    con  spazi  ");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Aggiunta elenco il cui nome è unna stringa lunga con caratteri
		// inusuali e speciali di utf8
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"«ταБЬℓσ»: 1<2 & 4+1>3, now 20% off!                          .\n okk                          erdgwdfhqehklnmhqkenmhqk eqaehgmqkemgkqmer er gqeqerh dfSDG SD ADFS G s g  G sdg ds G SDG SG SDG s ds g  G s dg sgd sG D G sg ");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Aggiunta elenco il cui nome è unna stringa lunga con caratteri
		// speciali
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"/[&\\#,+()$~%.'\":*?<>{}]/g,\'_\'");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Modifica nome elenco ed annulla
		solo.clickLongInList(1, 0);
		// Attende l'apertura della dialog
		solo.waitForDialogToOpen(5000);
		// Click su Edit
		solo.clickInList(1, 0);

		// Attende la successiva dialog di conferma
		solo.waitForDialogToOpen(5000);
		// Click su azione 2
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Si prova a rinominare lasciando il campo nome vuoto
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "");
		// Click su OK
		solo.clickOnView(solo.getView(android.R.id.button1));

		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on Edit
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Aggiunta di un nome con spazi aggiuntivi
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText),
				"nome lista mod");
		// Click su OK
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Inizia operazione di modifica e Annulla cliccando Back key
		solo.clickLongInList(1, 0);
		// Attende l'apertura della dialog
		solo.waitForDialogToOpen(5000);
		// Click su Edit
		solo.goBack();

		// Inizia operazione di modifica del nome e Annulla con il pulsante
		// 'Cancel'
		solo.clickLongInList(1, 0);
		// Attende la dialog
		solo.waitForDialogToOpen(5000);
		// Click su Edit
		solo.clickInList(1, 0);
		// Dalla dialog con il nome dell'elenco
		solo.waitForDialogToOpen(5000);
		// Clicca 'Cancel'
		solo.clickOnView(solo.getView(android.R.id.button2));

		// Annulla dalla dialog di digitazione con back
		solo.clickLongInList(1, 0);
		// Attante prima dialog
		solo.waitForDialogToOpen(5000);
		// Click su Edit
		solo.clickInList(1, 0);
		// Attende seconda dialog
		solo.waitForDialogToOpen(5000);
		solo.goBack();

		// Inizia eliminazione ma poi Annulla
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Delete
		solo.clickInList(2, 0);
		// Nella seconda dialog clicca Cancel
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button2));

		// Qui annulla con back key
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Delete
		solo.clickInList(2, 0);
		// Attende apertura dialog
		solo.waitForDialogToOpen(5000);
		solo.goBack();

		// Eliminazione con conferma
		solo.clickLongInList(1, 0);
		// Attende dialog
		solo.waitForDialogToOpen(5000);
		// Click su Delete
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Clicca Yes
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Elimina anche il secondo elenco rimasto
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Elimina anche il terzo elenco
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Elimina anche il quarto elenco
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Elimina anche il quinto elenco
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));
	}
}