package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;

public class SimplyDoItemTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
	private Solo solo;

	public SimplyDoItemTest() {
		super(SimplyDoActivity.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() {
		// Attesa del caricamento dell'activity:
		// 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Set default small timeout to 14193 milliseconds
		Timeout.setSmallTimeout(14193);
		// Aggiunta del primo elenco
		// Click sul campo di testo per inserire il nome dell'elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Inserimento del testo: 'lista 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "lista 1");
		// Click su pulsante 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Aggiunta di un secondo elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Inserimento del testo: 'lista 2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "lista 2");
		// Click su pulsante 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Click su 'lista 1'
		solo.clickInList(1, 0);
		// Click sul campo di testo per l'inserimento dell'azione
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Inserimento testo: 'azione 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "azione 1");
		// Click su 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Inserimento testo: 'azione 2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "azione 2");
		// Click su 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Click su 'azione 1' per disattivare l'azione
		solo.clickInList(1, 0);
		// Click su 'azione 2' per disatticare l'azione
		solo.clickInList(2, 0);

		// Rimozione di tutte le azioni inattive
		solo.clickOnActionBarItem(0x64);
		// Attesa per la finestra di dialogo
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Stessa operazione di rimozione su lista vuota
		solo.clickOnActionBarItem(0x64);
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Riaggiunge le due azioni
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// 'azione 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "azione 1");
		// Click su 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// 'azione 2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "azione 2");
		// Click su 'Add'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Prova aggiunta azione senza nome
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Ordinamento di tutte le azioni in elenco
		solo.clickOnActionBarItem(0x6b);

		// Ordinamento elenco vuoto
		// Elimina prima le due azioni presenti... click lungo su azione 1
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Delete'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);
		// Click lungo su azione 1
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Delete'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Prova ad ordinare elenco vuoto
		solo.clickOnActionBarItem(0x6b);

		// rimuovi items su lista piena senza item inattivi
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);

		// Spostamento azione in altro elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Crea tre azioni con attributi diversi
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione da spostare 1 starred");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione da spostare 2 inattiva");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione da spostare 3 attiva");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Spostamento azione con stellina
		// Marca l'azione con una stellina
		solo.clickLongInList(3, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Add Star'
		solo.clickInList(3, 0);
		// Spostamento
		solo.clickLongInList(3, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		// Conferma spostamento
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Spostamento Inactive
		// Prima disattiva
		solo.clickInList(2, 0);
		// Poi sposta
		solo.clickLongInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		// Scelta destinazione
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		// Conferma
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Spostamento azione attiva
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Test edit rename remove star and delete
		// Press menu back key
		solo.goBack();
		// Torna agli elenchi
		solo.clickInList(2, 0);
		// Ne apre uno
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on 'Edit'
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Digita la descrizione
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText),
				"azione mod");
		// Click su 'OK'
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Rinomina senza descrizione
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on Edit
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "");
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Rinomina con descrizione hint
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

		// Rimozione stellina
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on 'Add Star'
		solo.clickInList(3, 0);

		// Elimina azione
		// Long click 'azione 1'
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Delete'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);

		// Click su 'Delete' item e poi annulla
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on 'Delete'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click on 'Cancel'
		solo.clickOnView(solo.getView(android.R.id.button2));
		solo.waitForDialogToClose(5000);

		// Eliminazione delle due liste presenti per test successivo
		solo.goBack();
		solo.clickLongInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button1));

	}
}
