package caldwell.ben.trolly.test;

import java.util.ArrayList;

import caldwell.ben.trolly.Trolly;
import com.robotium.solo.*;

import android.content.Intent;
import android.test.ActivityInstrumentationTestCase2;


public class TrollyTest extends ActivityInstrumentationTestCase2<Trolly> {
  	private Solo solo;
  	
  	public TrollyTest() {
		super(Trolly.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		
		ArrayList<String> arrayString = new ArrayList<String>();
		arrayString.add("ItemA");
		arrayString.add("ItemB");
		arrayString.add("ItemC");
		Intent intent = new Intent();
		intent.putExtra(org.openintents.intents.ShoppingListIntents.EXTRA_STRING_ARRAYLIST_SHOPPING, arrayString);
		setActivityIntent(intent);
		
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'caldwell.ben.trolly.Trolly'
		solo.waitForActivity(caldwell.ben.trolly.Trolly.class, 2000);
		// Set default small timeout to 5000 milliseconds
		Timeout.setSmallTimeout(5000);
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item1");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item2'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item2");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item3");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on Item1
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Click on Item2
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Click on Item3
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Click on Item3
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Click on Item2
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Click on Item1
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Click on Item3
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on In trolley 
		solo.clickInList(1, 0);
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on On list 
		solo.clickInList(1, 0);
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Item1");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on Item1
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on On List 
		solo.clickInList(1, 0);
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// Long click Item3
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Item3");
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click Item3
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Item3");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click Item3
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		// Long click Item2
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click Item2
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item1");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item2'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item2");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item3");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		// Click on Item3
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Click on Item2
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		// Enter the text: 'Item2'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item2");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item3");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item1");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item2'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item2");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item3");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item1");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item2'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item2");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Enter the text: 'Item3'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Item3");
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Ascending
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Descending
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Modified Ascending
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.goBack();
		// Click on Item2
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Modified Descending
		solo.clickOnView(solo.getView(android.R.id.text1, 3));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Ascending
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Descending
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Modified Ascending
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Modified Descending
		solo.clickOnView(solo.getView(android.R.id.text1, 3));
		// Press menu back key
		solo.goBack();
		// Click on Item3
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		// Long click Item1
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Item1'
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Item1");
		// Click on Item1
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.edit));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click Empty Text View
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
	}
}
