package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);

		/*---------- creazione di liste --------------*/

		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Enter the text: 'Uno'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Uno");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'Due'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Due");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'Tre'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Tre");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'Quattro'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Quattro");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'Cinque'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Cinque");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));


		/*------ ordinamento liste : none (e verifica)-------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		// Enter the text: 'Zero'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Zero");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		/*------ ordinamento liste : alfabetico ------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();

		/*------ modifica lista ----------*/

		// Long click Zero (0/0)
		solo.clickLongInList(6, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Zero
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Enter the text: 'Sei'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "Sei");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));

		/*--------- elimina lista ---------*/

		// Long click Sei (0/0)
		solo.clickLongInList(6, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);

		/*------ crea azioni in lista -------*/

		// Click on Cinque (0/0)
		solo.clickInList(1, 0);
		// Enter the text: 'Detersivo'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Detersivo");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Sapone'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Sapone");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Pasta'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Pasta");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Pane'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Pane");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Melenzane'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Melenzane");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Pesche'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Pesche");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Pere'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Pere");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'Latte'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Latte");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));


		/*------- spostamento azioni ------*/

		// Long click Detersivo ImageSwitcher
		solo.clickLongInList(8, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Quattro
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));

		/*----- contrassegna azioni  ----*/

		// Click on Sapone ImageSwitcher
		solo.clickInList(7, 0);
		// Click on Pane ImageSwitcher
		solo.clickInList(5, 0);

		/*------- aggiungi star ad azione-----*/
		
		// Long click Pane ImageSwitcher
		solo.clickLongInList(5, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click Melenzane ImageSwitcher
		solo.clickLongInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);

		/*------- pulsante Sort Now ------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);

		/*------ ordinamento liste : none + pulsante sort now ------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();


		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);

		/*------ ordinamento liste : starred first + pulsante sort now------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Starred First
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);

		/*------ ordinamento liste : active first ------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Active First
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.goBack();
	
		/*-------- elimina azioni inattive ------*/

		// Click on Sapone ImageSwitcher
		solo.clickInList(7, 0);
		// Click on Pere ImageSwitcher
		solo.clickInList(4, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));


		// Click on Sapone ImageSwitcher
		solo.clickInList(5, 0);
		// Click on Pesche ImageSwitcher
		solo.clickInList(4, 0);

		/*-------- elimina azioni inattive senza dialog------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Confirm Delete All Inactive  LinearLayout
		solo.clickInList(3, 0);
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);

		/*------ backup------*/
	
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Press menu back key
		solo.goBack();

		/*------ elimina azione (precondizioni per restore)-----*/

		// Long click Pasta ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);

		/*------ modifica azione (precondizioni per restore)-----*/

		// Long click Latte ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Latte
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'Panna'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "Panna");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));


		/*------- restore ------*/

		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click on SimplyDo_20141215_57109
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Press menu back key
		solo.goBack();
		// Click on Cinque (3/3)
		solo.clickInList(1, 0);
		// Press menu back key
		solo.goBack();
	}
}
