package kdk.android.simplydo.test;

import kdk.android.simplydo.ItemListSorter;
import kdk.android.simplydo.SimplyDoActivity;

import com.robotium.solo.*;

import android.content.Context;
import android.preference.PreferenceManager;
import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTestWB extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
	private Solo solo;

	public SimplyDoActivityTestWB() {
		super(SimplyDoActivity.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Click on another_list (0/0)
		solo.clickInList(2, 0);
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click on SimplyDo_20151218_37681
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		solo.goBack();
		solo.goBack();
		// Enter the text: 'another-item'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "another-item");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Long click another-item ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on another_one
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Press menu back key
		solo.goBack();
		// Click on another_one (1/1)
		solo.clickInList(3, 0);
		// Long click another-item ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click another-item ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Remove Star 
		solo.clickInList(3, 0);
		// Click on another-item ImageSwitcher
		solo.clickInList(1, 0);
		// Click on another-item ImageSwitcher
		solo.clickInList(1, 0);
		// Press menu back key
		solo.goBack();
		// Click on another_one (1/1)
		solo.clickInList(3, 0);
		// Long click another-item ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on another_list
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Enter the text: '567hyu'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "567hyu");
		// Click on 567hyu
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Set default small timeout to 11056 milliseconds
		Timeout.setSmallTimeout(11056);
		// Enter the text: '567hyu@'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "567hyu@");
		// Set default small timeout to 13079 milliseconds
		Timeout.setSmallTimeout(13079);
		// Click on 567hyu@
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'ripuyt'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "ripuyt");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Long click another-item ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click ripuyt ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Click on 567hyu@ ImageSwitcher
		solo.clickInList(2, 0);
		// Click on 567hyu@ ImageSwitcher
		solo.clickInList(2, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Starred First
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Set default small timeout to 13140 milliseconds
		Timeout.setSmallTimeout(13140);
		// Press menu back key
		solo.goBack();
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Enter the text: 'ytrew3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "ytrew3");
		// Click on ytrew3
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Enter the text: 'ytrew3 yh'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "ytrew3 yh");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Press menu back key
		solo.goBack();
	}
}
