package caldwell.ben.trolly.test;

import caldwell.ben.trolly.Trolly;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class TrollyTestWB extends ActivityInstrumentationTestCase2<Trolly> {
  	private Solo solo;
  	
  	public TrollyTestWB() {
		super(Trolly.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'caldwell.ben.trolly.Trolly'
		solo.waitForActivity(caldwell.ben.trolly.Trolly.class, 2000);
		// Set default small timeout to 33983 milliseconds
		Timeout.setSmallTimeout(33983);
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on Pane
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Long click Latte
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on On list 
		solo.clickInList(1, 0);
		// Long click Latte
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		// Click on Add
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Press menu back key
		solo.goBack();
		// Click on Pane
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
	}
}
