package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class TippyTipperTest extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	
  	public TippyTipperTest() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		
		// -----------------------------------------------------
		// BLACK BOX TEST
		// -----------------------------------------------------
		
		blackBoxTest();
		
		// -----------------------------------------------------
		// WHITE BOX TEST
		// -----------------------------------------------------
		
		// Number Picker Coverage
		numberPickerCoverage();
		
	}
	
	private void blackBoxTest(){
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		// Set default small timeout to 11826 milliseconds
		Timeout.setSmallTimeout(11826);
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$0.08'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.08");
		// Click on net.mandaria.tippytipper.R$id.btn_seven
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		// Enter the text: '$0.87'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.87");
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$8.78'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$8.78");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$87.89'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$87.89");
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$0.02'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.02");
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.21'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.21");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$2.10'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2.10");
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Enter the text: '$21.05'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$21.05");
		// Click on net.mandaria.tippytipper.R$id.btn_six
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Enter the text: '$210.56'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$210.56");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$21.05'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$21.05");
		// Click on net.mandaria.tippytipper.R$id.btn_seven
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		// Enter the text: '$210.57'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$210.57");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$21.05'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$21.05");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$2.10'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2.10");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$0.21'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.21");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$2.19'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2.19");
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$21.98'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$21.98");
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Enter the text: '$219.85'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$219.85");
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.01'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.01");
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$0.12'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.12");
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Enter the text: '$1.25'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1.25");
		// Click on net.mandaria.tippytipper.R$id.btn_six
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Enter the text: '$12.56'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$12.56");
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Enter the text: '$125.63'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$125.63");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click on Default Tip Percentage Percentage to tip by default LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 12);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on First Tip Percentage Custom value for first tip percentage preset button Li
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 12);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Second Tip Percentage Custom value for second tip percentage preset button 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 13);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Scroll to Third Tip Percentage Custom value for third tip percentage preset button Li
		android.widget.ListView listView0 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView0, 2);
		// Click on Third Tip Percentage Custom value for third tip percentage preset button Li
		solo.clickOnText(java.util.regex.Pattern.quote("Third Tip Percentage"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 15);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Exclude Tax Rate"));
		// Scroll to Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		android.widget.ListView listView1 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView1, 3);
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '1'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "1");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '000'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "000");
		// Enter the text: '1'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "1");
		// Enter the text: '999'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "999");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '997'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "997");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '996'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "996");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Enter the text: '997'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "997");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Enter the text: '1'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "1");
		// Enter the text: '997'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "997");
		// Enter the text: '0'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '0'
//		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
//		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Click on Round Type Choose to round by tip or total LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Round Tip
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Scroll to Default Number People The number of people to split bill by LinearLayout
		android.widget.ListView listView2 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView2, 4);
		// Click on Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '3'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '3'
//		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
//		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		// Press menu back key
		solo.goBack();
		// Assert that: '$12.44' is shown
		assertTrue("'$12.44' is not shown!", solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.lbl_tip_amount)));
		// Assert that: '$138.07' is shown
		assertTrue("'$138.07' is not shown!", solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.lbl_total_amount)));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on 12%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Scroll to Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		android.widget.ListView listView3 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView3, 4);
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Exclude Tax Rate"));
		// Click on Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		// Press menu back key
		solo.goBack();
		// Click on 13%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
	}
	
	private void numberPickerCoverage(){
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click on Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement)); // 2
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement)); // 20		
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment)); // 2
	}
}
