package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
	
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		
		// --------------------------------------------------------------------------
		// White Box Section
		// --------------------------------------------------------------------------
		
		// RestoreActivity coverage
		restoreActivityCoverage();	
		
		// SimplyDoActivity coverage
		simplyDoActivityCoverage();
		
		// --------------------------------------------------------------------------
		// Black Box Section
		// --------------------------------------------------------------------------
	
		blackBoxTest();		
	
	}
	
	private void blackBoxTest(){
		// Set default small timeout to 10053 milliseconds
		Timeout.setSmallTimeout(10053);
		// Enter the text: 'item1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "item1");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Enter the text: 'item2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "item2");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'item3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "item3");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Click on item1 (0/0)
		solo.clickInList(1, 0);
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Enter the text: 'item1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item1");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'item2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item2");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'item3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item3");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on item3 ImageSwitcher
		solo.clickInList(1, 0);
		// Click on item1 ImageSwitcher
		solo.clickInList(3, 0);
		// Press menu back key
		solo.goBack();
		// Click on item2 (0/0)
		solo.clickInList(2, 0);
		// Enter the text: 'itemA'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemA");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'itemB'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemB");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'itemC'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemC");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'itemD'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemD");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on itemC ImageSwitcher
		solo.clickInList(2, 0);
		// Click on itemB ImageSwitcher
		solo.clickInList(3, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: 'itemE'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemE");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'itemF'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "itemF");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Set default small timeout to 14720 milliseconds
		Timeout.setSmallTimeout(14720);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Enter the text: '@'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "@");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on itemD ImageSwitcher
		solo.clickInList(4, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Starred First
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Long click itemA ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Press menu back key
		solo.goBack();
		// Click on item1 (1/3)
		solo.clickInList(1, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on Sort Now
		//solo.clickOnView(solo.getView(android.R.id.title, 1));
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Click on Confirm Delete All Inactive  LinearLayout
		solo.clickInList(3, 0);
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on item3 (0/0)
		solo.clickInList(3, 0);
		// Enter the text: 'e3fg'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "e3fg");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'aks3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "aks3");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'longitem--------'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "longitem--------");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on longitem-------- ImageSwitcher
		solo.clickInList(1, 0);
		// Click on aks3 ImageSwitcher
		solo.clickInList(2, 0);
		// Click on e3fg ImageSwitcher
		solo.clickInList(3, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Enter the text: 'item1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item1");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'item2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item2");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'item3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item3");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on item3 ImageSwitcher
		solo.clickInList(1, 0);
		// Click on item2 ImageSwitcher
		solo.clickInList(2, 0);
		// Click on item1 ImageSwitcher
		solo.clickInList(3, 0);
		// Long click item3 ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on item3
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'item4'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item4");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item2 ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Enter the text: 'item5'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item5");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Long click item5 ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'item5'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item5");
		// Click on item5
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'item6'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item6");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: 'item7'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item7");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Long click item7 ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Long click item6 ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Enter the text: 'item8'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item8");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Long click item7 ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on item1
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item1 ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Enter the text: 'item9'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item9");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Click on item9 ImageSwitcher
		solo.clickInList(1, 0);
		// Long click item9 ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Click on item2
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item8 ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click item4 ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Active First
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on item2 ImageSwitcher
		solo.clickInList(2, 0);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Press menu back key
		solo.goBack();
		// Long click item3 (2/2)
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click on SimplyDo_20141215_56217
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Click on Confirm Delete All Inactive  LinearLayout
		solo.clickInList(3, 0);
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		// Set default small timeout to 16946 milliseconds
		Timeout.setSmallTimeout(16946);
		// Long click item2 (4/5)
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on item2
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Enter the text: 'item22'
		//solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		//solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "item22");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item3 (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'item3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "item3");
		// Click on item3
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Enter the text: 'item3@'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "item3@");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '-'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "-");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Long click item1 (1/3)
		solo.clickLongInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		// Click on - (0/0)
		solo.clickInList(1, 0);
		// Enter the text: '-'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "-");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'a'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "a");
		// Set default small timeout to 17864 milliseconds
		Timeout.setSmallTimeout(17864);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Press menu back key
		solo.goBack();
		// Set default small timeout to 44560 milliseconds
		//Timeout.setSmallTimeout(44560);
		// Press menu back key
		//solo.goBack();
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		assertTrue("kdk.android.simplydo.SimplyDoActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class));
		// Set default small timeout to 44560 milliseconds
		//Timeout.setSmallTimeout(44560);
		// Click on - (2/2)
		solo.clickInList(1, 0);
		// Long click - ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on kdk.android.simplydo.R$id.EditItemLabelEditText
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'item'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item");
		// Click on Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Long click - ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: '-'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "-");
		// Click on kdk.android.simplydo.R$id.EditItemLabelEditText
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'item'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on item3@
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
	}
	
	private void restoreActivityCoverage(){
		// Restore DB => No
	
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Click on first backup entry
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Go back
		solo.goBack();
		// Set default small timeout to 17864 milliseconds
		Timeout.setSmallTimeout(17864);
	}
	
	private void simplyDoActivityCoverage(){
		// --------------------------------------
		// Delete item => No
		// --------------------------------------
	
		solo.goBack();
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Enter the text: 'item'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "item");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Long click on list
		solo.clickLongInList(1, 0);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// --------------------------------------
		// Delete all item but list is null
		// --------------------------------------
		
		// Enter List
		solo.clickInList(1, 0);
		// Click on Delete All Inactive
		solo.clickOnMenuItem("Delete All Inactive", true);
		solo.clickOnButton("Yes");	
		// Go Back
		solo.goBack();
		
		// --------------------------------------
		// Restore
		// --------------------------------------
		
		// Long click on list
		solo.clickLongInList(1, 0);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		
	}
}
