package info.bpace.munchlife.test;

import info.bpace.munchlife.MunchLifeActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class MunchLifeActivityTest extends ActivityInstrumentationTestCase2<MunchLifeActivity> {
  	private Solo solo;
  	
  	public MunchLifeActivityTest() {
		super(MunchLifeActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
	
		// ---------------------------------------------------
		// WHITE BOX TESTING
		// ---------------------------------------------------
		
		// Portrait & Landscape Coverage
		portraitLandscapeCoverage();
		
		// Win Dialog
		winDialogCoverage();
		
		// Max Level Coverage
		maxLevelCoverage();
		
		// Restore
		restore();
	
		// ---------------------------------------------------
		// BLACK BOX TESTING
		// ---------------------------------------------------
		
		blackBoxTesting();
		
	}
	
	private void maxLevelCoverage(){
		// Click on Change Settings 
		solo.clickOnMenuItem("Change Settings");
		// Wait for activity: 'info.bpace.munchlife.SettingsActivity'
		assertTrue("info.bpace.munchlife.SettingsActivity is not found!", solo.waitForActivity(info.bpace.munchlife.SettingsActivity.class));
		// Click on LinearLayout Max Level The level at which you win. LinearLayout
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on 10
		solo.clickOnView(solo.getView(android.R.id.edit));
		// Enter the text: '6'
		solo.clearEditText((android.widget.EditText) solo.getView(android.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(android.R.id.edit), "6");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Press menu back key
		solo.goBack();
	}
	
	private void portraitLandscapeCoverage(){
		// Change Orientation (MALE)
		solo.setActivityOrientation(Solo.LANDSCAPE);
		Timeout.setSmallTimeout(15000);
		solo.setActivityOrientation(Solo.PORTRAIT);
		Timeout.setSmallTimeout(15000);
		// Change Orientation (FEMALE)
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		solo.setActivityOrientation(Solo.LANDSCAPE);
		Timeout.setSmallTimeout(15000);
		solo.setActivityOrientation(Solo.PORTRAIT);
	}
	
	private void winDialogCoverage(){
		for(int i=0 ; i<9 ; i++)
			solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button)); // Click on Up a Level
		solo.clickOnButton("Okay");
	}
	
	private void restore(){
		for(int i=0 ; i<5 ; i++)
			solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button)); // Click on Down a Level
	}
	
	private void blackBoxTesting(){
		// Wait for activity: 'info.bpace.munchlife.MunchLifeActivity'
		solo.waitForActivity(info.bpace.munchlife.MunchLifeActivity.class, 2000);
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on Reset 
		solo.clickOnMenuItem("Reset");
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Roll Dice 
		solo.clickOnMenuItem("Roll Dice");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on Roll Dice 
		solo.clickOnMenuItem("Roll Dice");
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Roll Dice 
		solo.clickOnMenuItem("Roll Dice");
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Roll Dice 
		solo.clickOnMenuItem("Roll Dice");
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Reset 
		solo.clickOnMenuItem("Reset");
		// Click on Change Settings 
		solo.clickOnMenuItem("Change Settings");
		// Wait for activity: 'info.bpace.munchlife.SettingsActivity'
		assertTrue("info.bpace.munchlife.SettingsActivity is not found!", solo.waitForActivity(info.bpace.munchlife.SettingsActivity.class));
		// Click on LinearLayout Keep Screen Awake Keep screen from sleeping LinearLayout
		solo.clickInList(2, 0);
		// Press menu back key
		solo.goBack();
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Set default small timeout to 15765 milliseconds
		Timeout.setSmallTimeout(15765);
		// Click on ImageView
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on ImageView
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on ImageView
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		// Rotate the screen
		solo.setActivityOrientation(Solo.PORTRAIT);
		// Assert that: 'info.bpace.munchlife.R$id.total_level' is shown
		assertTrue("'info.bpace.munchlife.R$id.total_level' is not shown!", solo.waitForView(solo.getView(info.bpace.munchlife.R.id.total_level)));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Change Settings 
		solo.clickOnMenuItem("Change Settings");
		// Wait for activity: 'info.bpace.munchlife.SettingsActivity'
		assertTrue("info.bpace.munchlife.SettingsActivity is not found!", solo.waitForActivity(info.bpace.munchlife.SettingsActivity.class));
		// Click on LinearLayout Victory Dialog Select whether to display a dialog on reaching 
		solo.clickInList(3, 0);
		// Press menu back key
		solo.goBack();
		// Click on Reset 
		solo.clickOnMenuItem("Reset");
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Add Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_gear_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Change Settings 
		solo.clickOnMenuItem("Change Settings");
		// Wait for activity: 'info.bpace.munchlife.SettingsActivity'
		assertTrue("info.bpace.munchlife.SettingsActivity is not found!", solo.waitForActivity(info.bpace.munchlife.SettingsActivity.class));
		// Click on LinearLayout Victory Dialog Select whether to display a dialog on reaching 
		solo.clickInList(3, 0);
		// Press menu back key
		solo.goBack();
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Up a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.up_button));
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Click on Down a Level
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_button));
		// Click on Remove Gear
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.down_gear_button));
		// Click on ImageView
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		// Click on ImageView
		solo.clickOnView(solo.getView(info.bpace.munchlife.R.id.gender));
		// Click on Reset 
		solo.clickOnMenuItem("Reset");
		// Click on Roll Dice 
		solo.clickOnMenuItem("Roll Dice");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Okay
		solo.clickOnView(solo.getView(android.R.id.button3));
		// Set default small timeout to 22013 milliseconds
		Timeout.setSmallTimeout(22013);
		// Click on Change Settings 
		solo.clickOnMenuItem("Change Settings");
		// Wait for activity: 'info.bpace.munchlife.SettingsActivity'
		assertTrue("info.bpace.munchlife.SettingsActivity is not found!", solo.waitForActivity(info.bpace.munchlife.SettingsActivity.class));
		// Press menu back key
		solo.goBack();
	}
}
