package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;

import android.test.ActivityInstrumentationTestCase2;


public class WBTippyTipperTest extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	
  	public WBTippyTipperTest() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		// Set default small timeout to 32437 milliseconds
		Timeout.setSmallTimeout(32437);
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.01'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.01");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$0.10'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.10");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$1.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1.00");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$10.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$10.00");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click on Default Tip Percentage Percentage to tip by default LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 0);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Set default small timeout to 16995 milliseconds
		Timeout.setSmallTimeout(16995);
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 40);
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Set default small timeout to 75459 milliseconds
		Timeout.setSmallTimeout(75459);
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$100.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$100.00");
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$10.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$10.00");
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$0.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Press menu back key
		solo.goBack();
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$0.02'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.02");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$0.20'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.20");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$2.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2.00");
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Enter the text: '$20.03'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$20.03");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickInList(7, 0);
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickInList(8, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '1'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "1");
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '2'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Click on 000
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		// Enter the text: '2'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Enter the text: '021'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "021");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Press menu back key
		solo.goBack();
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Press menu back key
		solo.goBack();
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Press menu back key
		solo.goBack();
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		// Assert that: 'Tippy Tipper' is shown
		assertTrue("'Tippy Tipper' is not shown!", solo.waitForView(solo.getView(android.R.id.title)));
		// Assert that: ' * Updated main layout: now includes a CLEAR and Calculate! button  ' is shown
		assertTrue("' * Updated main layout: now includes a CLEAR and Calculate! button  \n * Enabled install to SD card, prefers external  \n * Reduced space (removed duplicate images) \n * Thanks to Stephen Donaldson, Jr. for submitted patch \n' is not shown!", solo.waitForText(java.util.regex.Pattern.quote(" * Updated main layout: now includes a CLEAR and Calculate! button  \n * Enabled install to SD card, prefers external  \n * Reduced space (removed duplicate images) \n * Thanks to Stephen Donaldson, Jr. for submitted patch \n")));
		// Set default small timeout to 11824 milliseconds
		Timeout.setSmallTimeout(11824);
		// Press menu back key
		solo.goBack();
		// Set default small timeout to 185459 milliseconds
		Timeout.setSmallTimeout(185459);
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Press menu back key
		solo.goBack();
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.01'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.01");
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$0.12'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.12");
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Enter the text: '$1.23'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1.23");
		// Click on net.mandaria.tippytipper.R$id.btn_four
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_four));
		// Enter the text: '$12.34'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$12.34");
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Enter the text: '$123.45'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$123.45");
		// Click on net.mandaria.tippytipper.R$id.btn_six
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Enter the text: '$1,234.56'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1,234.56");
		// Click on net.mandaria.tippytipper.R$id.btn_seven
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		// Enter the text: '$12,345.67'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$12,345.67");
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$123,456.78'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$123,456.78");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$1,234,567.89'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1,234,567.89");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$12,345,678.90'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$12,345,678.90");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
	}
}
