package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class TippyTipperTestWithoutChangingSettings extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	
  	public TippyTipperTestWithoutChangingSettings() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		// Set default small timeout to 50675 milliseconds
		Timeout.setSmallTimeout(50675);
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.01'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.01");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$0.19'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.19");
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$1.98'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1.98");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$19.89'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$19.89");
		// Set default small timeout to 213373 milliseconds
		Timeout.setSmallTimeout(213373);
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 18);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 31);
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
	}
}
