import os
import settings
import logging
import re

# returns a list of directories nested in the given path (which must be a directory itself)
def listDirectories(path):
    return next(os.walk(path))[1]

def computeCoverageUnion(aut, subjects):
    for strategy in ["WhiteBox", "BlackBox"]:
        # create folder if necessary
        resultsPath = settings.resultsPath + "\\" + str(len(subjects))
        if not( os.path.exists(resultsPath) ):
            os.makedirs(resultsPath)
        
        # prepare system command to run emma
        unionCommand = "java -cp .\emma-2.0.5312\lib\emma.jar emma merge -quiet"
        for subject in subjects:
            #unionCommand += "-in "+ settings.coveragePath+ +"\\" + aut + "\\" + subject + "\\" + strategy + "\\" + "coverage.ec"
            unionCommand += " -in %s\\%s\\%s\\%s\\coverage.ec" % (settings.coveragePath, aut, subject, strategy)
        unionCommand += " -out %s\\%s_%s_%s.es" % (resultsPath,aut,strategy,"_".join(subjects))
        
        if not( os.path.exists("%s\\%s_%s_%s.es" % (resultsPath,aut,strategy,"_".join(subjects)) ) ):
            os.system(unionCommand)
        #logging.info(unionCommand)

        # generate txt report
        reportCommand = "java -cp .\\emma-2.0.5312\\lib\\emma.jar emma report -quiet -sourcepath .\\Source\\%s\\src -r txt -Dreport.txt.out.file=%s\\%s_%s_%s.txt -in .\em\%s\coverage.em,%s\\%s_%s_%s.es" % (aut,resultsPath,aut,strategy,"_".join(subjects),aut,resultsPath,aut,strategy,"_".join(subjects))
        
        #logging.info(reportCommand)
        if not( os.path.exists("%s\\%s_%s_%s.txt" % (resultsPath,aut,strategy,"_".join(subjects)) ) ):
            os.system(reportCommand)

def computeLOCCoverageUnion(aut, subjects):
    for strategy in ["WhiteBox", "BlackBox"]:
        # create folder if necessary
        c = len(subjects)
        tempPath = settings.temporaryPath + "\\"# + str(c)
        if not( os.path.exists(tempPath) ):
            os.makedirs(tempPath)
        
        # prepare system command to run emma
        unionCommand = "java -cp .\emma-2.0.5312\lib\emma.jar emma merge -quiet"
        for subject in subjects:
            #unionCommand += "-in "+ settings.coveragePath+ +"\\" + aut + "\\" + subject + "\\" + strategy + "\\" + "coverage.ec"
            unionCommand += " -in %s\\%s\\%s\\%s\\coverage.ec" % (settings.coveragePath, aut, subject, strategy)
        unionCommand += " -out %s\\%s_%d.es" % (tempPath,aut,c)
        
        #if failsafe
        os.system(unionCommand)
        #logging.info(unionCommand)

        # generate txt report
        reportCommand = "java -cp .\\emma-2.0.5312\\lib\\emma.jar emma report -quiet -sourcepath .\\Source\\%s\\src -r txt -Dreport.txt.out.file=%s\\%s_%d.txt -in .\em\%s\coverage.em,%s\\%s_%d.es" % (aut,tempPath,aut,c,aut,tempPath,aut,c)
        
        #logging.info(reportCommand)
        #if not( os.path.exists("%s\\%s_%s_%s.txt" % (tempPath,aut,strategy,"_".join(subjects)) ) ):
        os.system(reportCommand)

        with open("%s\\%s_%d.txt" % (tempPath, aut, c) ) as txtReport:
            for _ in range(5):
                txtReport.readline(); #skip first five lines
            overallCoverage = txtReport.readline()
            txtReport.close()
            LOCData = re.split('\t',overallCoverage)[3]
            coveredLOC = re.split('/|\(|\)', LOCData)[1]
            totalLOC   = re.split('/|\(|\)', LOCData)[2]
            coveredLOC = float(coveredLOC.replace(',','.'))
            totalLOC = float(totalLOC.replace(',','.'))
            totalLOC -= settings.emmaInstrumentLOCs #remove emma instrumentations locs
            coverage = coveredLOC/totalLOC
            return coverage
            #dataframe.append([aut, c, subset, strategy, coverage])