package net.mandaria.tippytipper.preferences;

import net.mandaria.tippytipper.R;
import net.mandaria.tippytipper.widgets.*;
import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.preference.DialogPreference;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.content.res.*;

//import it.unina.dieti.Logcelot.Logcelot;

public class NumberPickerPreference extends DialogPreference
{
	private static final String androidns = "http://schemas.android.com/apk/res/android";
	private static final String appns = "http://schemas.android.com/apk/res/net.mandaria.tippytipper";

	private NumberPicker mPickInteger;
	private TextView mSplashText, mValueText;
	private Context mContext;

	private String mDialogMessage, mSuffix;
	private int mDefault, mMin, mMax, mValue = 0;

	public NumberPickerPreference(Context context, AttributeSet attrs)
	{
		super(context, attrs);
		//Logcelot.log("NumberPickerPreference.NumberPickerPreference()");
		mContext = context;

		mDialogMessage = attrs.getAttributeValue(androidns, "dialogMessage");
		mSuffix = attrs.getAttributeValue(androidns, "text");
		mDefault = attrs.getAttributeIntValue(androidns, "defaultValue", 0);
		mMax = attrs.getAttributeIntValue(androidns,"max", 100);
	    
	    TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBarPreference);
	    mMin = a.getInt(R.styleable.SeekBarPreference_min, 0);
	}

	@Override
	protected View onCreateDialogView()
	{
		//Logcelot.log("NumberPickerPreference.onCreateDialogView()");
		TableLayout.LayoutParams params;
		TableLayout layout = new TableLayout(mContext);
		layout.setPadding(6, 6, 6, 6);

		mSplashText = new TextView(mContext);
		if (mDialogMessage != null) {
			//Logcelot.log("NumberPickerPreference.onCreateDialogView().(mDialogMessage != null)");
			mSplashText.setText(mDialogMessage);
		}

		TableRow row_header = new TableRow(mContext);
		row_header.addView(mSplashText);

		mPickInteger = new NumberPicker(mContext);
		mPickInteger.setRange(mMin, mMax);

		TextView suffix = new TextView(mContext);
		suffix.setText(mSuffix);
		suffix.setTextSize(32);

		TableRow row_one = new TableRow(mContext);
		row_one.setGravity(Gravity.CENTER);
		row_one.addView(mPickInteger);
		row_one.addView(suffix);

		layout.addView(row_header);

		TableLayout table_main = new TableLayout(mContext);
		table_main.addView(row_one);

		TableRow row_main = new TableRow(mContext);
		row_main.setGravity(Gravity.CENTER_HORIZONTAL);
		row_main.addView(table_main);

		layout.addView(row_main);

		if (shouldPersist()) {
			//Logcelot.log("NumberPickerPreference.onCreateDialogView().(shouldPersist())");
			mValue = getPersistedInt(mDefault);
		}

		bindData();

		return layout;
	}

	private void bindData()
	{
		//Logcelot.log("NumberPickerPreference.bindData()");
		try
		{
			//Logcelot.log("NumberPickerPreference.bindData(.try)");
			mPickInteger.setCurrent(mValue);
		}
		catch (Exception ex)
		{
			//Logcelot.log("NumberPickerPreference.bindData(.try).catch");
			
		}
	}

	@Override
	protected void onBindDialogView(View v)
	{
		super.onBindDialogView(v);
		//Logcelot.log("NumberPickerPreference.onBindDialogView()");
		bindData();
	}

	@Override
	protected void onSetInitialValue(boolean restore, Object defaultValue)
	{
		super.onSetInitialValue(restore, defaultValue);
		//Logcelot.log("NumberPickerPreference.onSetInitialValue()");
		if (restore)
		{
			//Logcelot.log("NumberPickerPreference.onSetInitialValue().restore");
			try
			{
				//Logcelot.log("NumberPickerPreference.onSetInitialValue().restore.try");
				mValue = shouldPersist() ? getPersistedInt(mDefault) : 0;
			}
			catch (Exception ex)
			{
				//Logcelot.log("NumberPickerPreference.onSetInitialValue().restore.try.catch");
				mValue = mDefault;
			}
		}
		else {
			//Logcelot.log("NumberPickerPreference.onSetInitialValue().restore.else");
			mValue = (Integer) defaultValue;
		}
	}

	@Override
	protected void onDialogClosed(boolean positiveResult)
	{
		//Logcelot.log("NumberPickerPreference.onDialogClosed");
		if (positiveResult == true)
		{
			//Logcelot.log("NumberPickerPreference.onDialogClosed.(positiveResult == true)");
			super.onDialogClosed(positiveResult);
			// HACK: "click" both picker inputs to validate inputs before closing the dialog
			// this is to fix a problem of closing the dialog not causing the onFocusChange of the picker
			// to be called
			mPickInteger.onClick(null);
			mValue = mPickInteger.getCurrent();
			if (shouldPersist()) {
				//Logcelot.log("NumberPickerPreference.onDialogClosed.(positiveResult == true).shouldPersist");
				persistInt(mValue);
			}
		}
	}
}
