package net.mandaria.tippytipper.activities;

import java.util.HashMap;
import java.util.Map;

import com.flurry.android.FlurryAgent;

import net.mandaria.tippytipper.R;
import net.mandaria.tippytipper.TippyTipperApplication;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.*;
import android.view.View.OnClickListener;
import android.widget.*;
import android.widget.SeekBar.OnSeekBarChangeListener;

//import it.unina.dieti.Logcelot.Logcelot;

public class Total extends Activity {

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.total);
		//Logcelot.log("Total.onCreate()");
        
        TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
        
        calculateTip(appState.service.getTipPercentageAsDouble());
        
        View btn_SplitBill = findViewById(R.id.btn_SplitBill);
        btn_SplitBill.setOnClickListener(new OnClickListener() 
        	{
            	public void onClick(View v) 
            	{
					//Logcelot.log("Total.onCreate().btn_SplitBillonClick");
            		splitBillWithDefaultNumberOfPeople();
            		
            		Intent i = new Intent(getBaseContext(), SplitBill.class);
            		startActivity(i);
            	}
            });
//        Drawable d_SplitBill = findViewById(R.id.btn_SplitBill).getBackground();
//        int green = Color.parseColor("#216C2A");
//        PorterDuffColorFilter filter_green = new PorterDuffColorFilter(green, PorterDuff.Mode.SRC_ATOP);
//        d_SplitBill.setColorFilter(filter_green);
		
        View btn_round_down = findViewById(R.id.btn_round_down);
        btn_round_down.setOnClickListener(new OnClickListener() 
        	{
            	public void onClick(View v) 
            	{
					//Logcelot.log("Total.onCreate().btn_round_down.setOnClickListener");
            		roundDown();
            	}
            });
        
        View btn_round_up = findViewById(R.id.btn_round_up);
        btn_round_up.setOnClickListener(new OnClickListener() 
        	{
            	public void onClick(View v) 
            	{
					//Logcelot.log("Total.onCreate().btn_round_up.setOnClickListener");
            		roundUp();
            	}
            });
		
		SeekBar seek_tip_percentage = (SeekBar)findViewById(R.id.seek_tip_percentage);
		seek_tip_percentage.setOnSeekBarChangeListener(new OnSeekBarChangeListener()
			{	
				@Override
				public void onProgressChanged(SeekBar seekBar, int progress,
						boolean fromUser)
				{
					//Logcelot.log("Total.onCreate().seek_tip_percentageonProgressChanged");
					if(fromUser)
					{
						//Logcelot.log("Total.onCreate().seek_tip_percentageonProgressChanged.(fromUser)");
						calculateTip((double)progress);
					}
				}

				@Override
				public void onStartTrackingTouch(SeekBar seekBar)
				{
					//Logcelot.log("Total.onCreate().seek_tip_percentage.onStartTrackingTouch");
					// TODO Auto-generated method stub
					
				}

				@Override
				public void onStopTrackingTouch(SeekBar seekBar)
				{
					//Logcelot.log("Total.onCreate().seek_tip_percentage.onStopTrackingTouch");
					tipPercentageSliderOnStopTouch();
				}
			});
		
    }
    
    /* Called after onCreate or onRestart */
	@Override
	public void onStart()
	{
		super.onStart();
		//Logcelot.log("Total.onStart()");
		boolean enableErrorLogging = Settings.getEnableErrorLogging(getBaseContext());
        String API = getString(R.string.flurrykey);
        if(!API.equals("") && enableErrorLogging == true)
		{
			//Logcelot.log("Total.onStart().if(!API.equals(\"\") && enableErrorLogging == true)");
			FlurryAgent.setContinueSessionMillis(30000);
			FlurryAgent.onStartSession(this, API);
		}
		
		refreshBillAmount();
		
		Button btn_TipAmount1 = (Button)findViewById(R.id.btn_TipAmount1);
        double tipPercentagePresetOne = Settings.getTipPercentagePresetOne(getBaseContext());
        btn_TipAmount1.setText((int)tipPercentagePresetOne + "%");
        btn_TipAmount1.setOnClickListener(new OnClickListener() 
    	{
        	public void onClick(View v) 
        	{
				//Logcelot.log("Total.onStart().btn_TipAmount1.onClick");
        		double tipPercentagePresetOne = Settings.getTipPercentagePresetOne(getBaseContext());
        		calculateTip(tipPercentagePresetOne);
        		
        		Map<String, String> params = new HashMap<String, String>();
        		params.put("Tip Percentage Preset", String.valueOf(tipPercentagePresetOne));
        		FlurryAgent.onEvent("Tip Preset One Button", params);
        	}
        });
        
        Button btn_TipAmount2 = (Button)findViewById(R.id.btn_TipAmount2);
        double tipPercentagePresetTwo = Settings.getTipPercentagePresetTwo(getBaseContext());
        btn_TipAmount2.setText((int)tipPercentagePresetTwo + "%");
        btn_TipAmount2.setOnClickListener(new OnClickListener() 
    	{
        	public void onClick(View v) 
        	{
				//Logcelot.log("Total.onStart().btn_TipAmount2.onClick");
        		double tipPercentagePresetTwo = Settings.getTipPercentagePresetTwo(getBaseContext());
        		calculateTip(tipPercentagePresetTwo);
        		
        		Map<String, String> params = new HashMap<String, String>();
        		params.put("Tip Percentage Preset", String.valueOf(tipPercentagePresetTwo));
        		FlurryAgent.onEvent("Tip Preset Two Button", params);
        	}
        });
        
        Button btn_TipAmount3 = (Button)findViewById(R.id.btn_TipAmount3);
        double tipPercentagePresetThree = Settings.getTipPercentagePresetThree(getBaseContext());
        btn_TipAmount3.setText((int)tipPercentagePresetThree + "%");
        btn_TipAmount3.setOnClickListener(new OnClickListener() 
    	{
        	public void onClick(View v) 
        	{
				//Logcelot.log("Total.onStart().btn_TipAmount3.onClick");
        		double tipPercentagePresetThree = Settings.getTipPercentagePresetThree(getBaseContext());
        		calculateTip(tipPercentagePresetThree);
        		
        		Map<String, String> params = new HashMap<String, String>();
        		params.put("Tip Percentage Preset", String.valueOf(tipPercentagePresetThree));
        		FlurryAgent.onEvent("Tip Preset Three Button", params);
        	}
        });
	}
	
	 @Override
	public void onStop()
    {
       super.onStop();
		//Logcelot.log("Total.onStop()");
       FlurryAgent.onEndSession(this);
    }
    
    @Override
  	public boolean onCreateOptionsMenu(Menu menu)
  	{
  		super.onCreateOptionsMenu(menu);
		//Logcelot.log("Total.onCreateOptionsMenu()");
  		MenuInflater inflater = getMenuInflater();
  		inflater.inflate(R.menu.menu, menu);
  		FlurryAgent.onEvent("Menu Button");
  		return true;
  	}

  	@Override
  	public boolean onOptionsItemSelected(MenuItem item)
  	{
		//Logcelot.log("Total.onOptionsItemSelected()");
  		switch(item.getItemId())
  		{
  			case R.id.settings:
				//Logcelot.log("Total.onOptionsItemSelected().settings");
  				startActivity(new Intent(this, Settings.class));
  				FlurryAgent.onEvent("Settings Button");
  				return true;
  			case R.id.about:
				//Logcelot.log("Total.onOptionsItemSelected().about");
  				startActivity(new Intent(this, About.class));
  				FlurryAgent.onEvent("About Button");
				return true;
  		}
		//Logcelot.log("Total.onOptionsItemSelected().default");
  		return false;
  	}
  	
  	private void tipPercentageSliderOnStopTouch()
  	{
		//Logcelot.log("Total.tipPercentageSliderOnStopTouch()");
  		TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
		Map<String, String> params = new HashMap<String, String>();
		params.put("Bill Amount", appState.service.getBillAmount());
		params.put("Tax Amount", appState.service.getTaxAmount());
		params.put("Tip Amount", appState.service.getTipAmount());
		params.put("Tip Percentage", appState.service.getTipPercentage());
		params.put("Tax Percentage", appState.service.getTaxPercentage());
		
		FlurryAgent.onEvent("Tip Percentage Slider", params);
  	}
  	
  	private void splitBillWithDefaultNumberOfPeople()
  	{
		//Logcelot.log("Total.splitBillWithDefaultNumberOfPeople()");
  		TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
  		int numberOfPeople = Settings.getDefaultNumberOfPeopleToSplitBill(getBaseContext());
  		
  		Map<String, String> params = new HashMap<String, String>();
		params.put("Default Number Of People", String.valueOf(numberOfPeople));
		params.put("Bill Amount", appState.service.getBillAmount());
		params.put("Tax Amount", appState.service.getTaxAmount());
		params.put("Tip Amount", appState.service.getTipAmount());
		params.put("Total Amount", appState.service.getTotalAmount());
		params.put("Tip Percentage", appState.service.getTipPercentage());
		params.put("Tax Percentage", appState.service.getTaxPercentage());
		FlurryAgent.onEvent("Split Bill Button", params);
		
		appState.service.splitBill(numberOfPeople);
  	}
    
    private void calculateTip(Double percent)
    {
		//Logcelot.log("Total.splitBillWithDefaultNumberOfPeople()");
		TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
		float excludeTaxRate = Settings.getExcludeTaxRate(getBaseContext());
		boolean enableExcludeTaxRate = Settings.getEnableExcludeTaxRate(getBaseContext());
		if(enableExcludeTaxRate == false) {
			//Logcelot.log("Total.splitBillWithDefaultNumberOfPeople().(enableExcludeTaxRate == false)");
			excludeTaxRate = 0;
		}
		//appState.service.CalculateTip(percent/100.0);
		appState.service.calculateTip(percent/100.0, excludeTaxRate/100.0);

		bindData();
    }
    
    private void roundDown()
    {
		//Logcelot.log("Total.roundDown()");
    	TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
    	boolean roundTip = Settings.isSetToRoundByTip(getBaseContext());
    	
    	String preRoundTipAmount = appState.service.getTipAmount();
    	String preRoundTotalAmount = appState.service.getTotalAmount();
    	
    	appState.service.roundDown(roundTip);
    	
    	Map<String, String> params = new HashMap<String, String>();
		params.put("Round Tip", String.valueOf(roundTip));
		params.put("Pre Round Tip Amount", preRoundTipAmount);
		params.put("Pre Round Total Amount", preRoundTotalAmount);
		params.put("Bill Amount", appState.service.getBillAmount());
		params.put("Tax Amount", appState.service.getTaxAmount());
		params.put("Tip Amount", appState.service.getTipAmount());
		params.put("Total Amount", appState.service.getTotalAmount());
    	FlurryAgent.onEvent("Round Down Button", params);
    	
    	bindData();
    }
    
    private void roundUp()
    {
		//Logcelot.log("Total.roundUp()");
    	TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
    	boolean roundTip = Settings.isSetToRoundByTip(getBaseContext());
    	
    	String preRoundTipAmount = appState.service.getTipAmount();
    	String preRoundTotalAmount = appState.service.getTotalAmount();
    	
    	appState.service.roundUp(roundTip);
    	
    	Map<String, String> params = new HashMap<String, String>();
		params.put("Round Tip", String.valueOf(roundTip));
		params.put("Pre Round Tip Amount", preRoundTipAmount);
		params.put("Pre Round Total Amount", preRoundTotalAmount);
		params.put("Bill Amount", appState.service.getBillAmount());
		params.put("Tax Amount", appState.service.getTaxAmount());
		params.put("Tip Amount", appState.service.getTipAmount());
		params.put("Total Amount", appState.service.getTotalAmount());
    	FlurryAgent.onEvent("Round Up Button", params);
    	
    	bindData();
    }
    
    public void refreshBillAmount()
    {
		//Logcelot.log("Total.refreshBillAmount()");
    	TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
		double tipPercent = appState.service.getTipPercentageAsDouble();
		float excludeTaxRate = Settings.getExcludeTaxRate(getBaseContext());
		boolean enableExcludeTaxRate = Settings.getEnableExcludeTaxRate(getBaseContext());
		if(enableExcludeTaxRate == false) {
			//Logcelot.log("Total.refreshBillAmount().(enableExcludeTaxRate == false)");
			excludeTaxRate = 0;
		}
		if(excludeTaxRate == 0)
		{
			//Logcelot.log("Total.refreshBillAmount().(enableExcludeTaxRate == false).excludeTaxRate == 0)");
			appState.service.refreshBillAmount();
			appState.service.calculateTip(appState.service.getTipPercentageAsDouble()/100.0, excludeTaxRate);
			bindData();
		}
		else {
			//Logcelot.log("Total.refreshBillAmount().(enableExcludeTaxRate == false).excludeTaxRate == 0)");
			calculateTip(tipPercent);
		}
    }
    
    private void bindData()
    {
		//Logcelot.log("Total.bindData()");
    	TippyTipperApplication appState = ((TippyTipperApplication)this.getApplication());
    	
    	TextView lbl_bill_amount = (TextView)findViewById(R.id.lbl_bill_amount);
		TextView lbl_tip_amount = (TextView)findViewById(R.id.lbl_tip_amount);
		TextView lbl_total_amount = (TextView)findViewById(R.id.lbl_total_amount);
		//TextView lbl_tip_percentage = (TextView)findViewById(R.id.lbl_tip_percentage);
		SeekBar seek_tip_percentage = (SeekBar)findViewById(R.id.seek_tip_percentage);
		View inflated_excludetax = findViewById(R.id.inflated_excludeTax);
		TextView lbl_tip_text = (TextView)findViewById(R.id.lbl_tip_text);
		
		float excludeTaxRate = Settings.getExcludeTaxRate(getBaseContext());
		boolean enableExcludeTaxRate = Settings.getEnableExcludeTaxRate(getBaseContext());
		if(enableExcludeTaxRate == false) {
			//Logcelot.log("Total.bindData().enableExcludeTaxRate == false)");
			excludeTaxRate = 0;
		}
		if(excludeTaxRate != 0)
		{
			//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0)");
			ViewStub stub_excludeTax = (ViewStub)findViewById(R.id.stub_excludeTax);
			if(stub_excludeTax != null) {
				//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null)");
				stub_excludeTax.setVisibility(View.VISIBLE);
			}
			else {
				//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null).else");
				if (inflated_excludetax != null){
					//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null).else.(inflated_excludetax != null)");
					inflated_excludetax.setVisibility(View.VISIBLE);
				}
			}
			TextView lbl_tax_amount = (TextView)findViewById(R.id.lbl_tax_amount);
			lbl_tax_amount.setText(appState.service.getTaxAmount());
			
			// Add (tax%): to label
			TextView lbl_tax_text = (TextView)findViewById(R.id.lbl_tax_text);
			String tax_text = lbl_tax_text.getText().toString();
			if(!tax_text.contains(appState.service.getTaxPercentage())) {
				//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null).!tax_text.contains(appState.service.getTaxPercentage()))");
				lbl_tax_text.setText(this.getString(R.string.tax).replace(":", " (" + appState.service.getTaxPercentage() + "):"));
			}
		}
		else
		{
			//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null).!tax_text.contains(appState.service.getTaxPercentage())).else");
			if(inflated_excludetax != null) {
				//Logcelot.log("Total.bindData().enableExcludeTaxRate == false).(excludeTaxRate != 0).(stub_excludeTax != null).!tax_text.contains(appState.service.getTaxPercentage())).else.(inflated_excludetax != null)");
				inflated_excludetax.setVisibility(View.GONE);
			}
		}

		// Add (tip%): to label
		String tip_text = lbl_tip_text.getText().toString();
		if(!tip_text.contains(appState.service.getTipPercentage())) {
			//Logcelot.log("Total.bindData()");
			lbl_tip_text.setText(this.getString(R.string.tip).replace(":", " (" + appState.service.getTipPercentage() + "):"));
		}
		//lbl_tip_percentage.setText(appState.service.GetTipPercentage());
		lbl_bill_amount.setText(appState.service.getBillAmount());
		lbl_tip_amount.setText(appState.service.getTipAmount());
		lbl_total_amount.setText(appState.service.getTotalAmount());
		seek_tip_percentage.setProgress(appState.service.getTipPercentageRounded());
    }
}
