package net.mandaria.tippytipper.activities;

import com.flurry.android.FlurryAgent;

import net.mandaria.tippytipper.R;
import android.os.Bundle;
import android.preference.*;
import android.content.Context;

//import it.unina.dieti.Logcelot.Logcelot;

public class Settings extends PreferenceActivity
{

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		//Logcelot.log("Settings.onCreate()");
		addPreferencesFromResource(R.xml.settings);
	}
	
	@Override
	public void onStart()
    {
       super.onStart();
		//Logcelot.log("Settings.onCreate()");
       boolean enableErrorLogging = Settings.getEnableErrorLogging(getBaseContext());
       String API = getString(R.string.flurrykey);
       if(!API.equals("") && enableErrorLogging == true)
       {
		   //Logcelot.log("Settings.onCreate())(!API.equals() && enableErrorLogging == true");
    	   FlurryAgent.setContinueSessionMillis(30000);
    	   FlurryAgent.onStartSession(this, API);
       }
    }
    
    @Override
	public void onStop()
    {
       super.onStop();
		//Logcelot.log("Settings.onStop()");
       FlurryAgent.onEndSession(this);
    }
	
	public static int getDefaultTipPercentage(Context context)
	{
		//Logcelot.log("Settings.getDefaultTipPercentage()");
		return PreferenceManager.getDefaultSharedPreferences(context).getInt("default_tip_percentage", 15);
	}
	
	public static int getTipPercentagePresetOne(Context context)
	{
		//Logcelot.log("Settings.getTipPercentagePresetOne()");
		return PreferenceManager.getDefaultSharedPreferences(context).getInt("tip_percentage_one", 10);
	}
	
	public static int getTipPercentagePresetTwo(Context context)
	{
		//Logcelot.log("Settings.getTipPercentagePresetTwo()");
		return PreferenceManager.getDefaultSharedPreferences(context).getInt("tip_percentage_two", 15);
	}
	
	public static int getTipPercentagePresetThree(Context context)
	{
		//Logcelot.log("Settings.getTipPercentagePresetThree()");
		return PreferenceManager.getDefaultSharedPreferences(context).getInt("tip_percentage_three", 20);
	}
	
	public static int getDefaultNumberOfPeopleToSplitBill(Context context)
	{
		//Logcelot.log("Settings.getDefaultNumberOfPeopleToSplitBill()");
		return PreferenceManager.getDefaultSharedPreferences(context).getInt("default_number_of_people", 2);
	}
	
	public static boolean getEnableErrorLogging(Context context)
	{
		//Logcelot.log("Settings.getEnableErrorLogging()");
		return PreferenceManager.getDefaultSharedPreferences(context).getBoolean("enable_error_logging", true);
	}
	
	public static boolean getEnableExcludeTaxRate(Context context)
	{
		//Logcelot.log("Settings.getEnableExcludeTaxRate()");
		return PreferenceManager.getDefaultSharedPreferences(context).getBoolean("enable_exclude_tax_rate", false);
	}
	
	public static boolean isSetToRoundByTip(Context context)
	{
		//Logcelot.log("Settings.isSetToRoundByTip()");
		String RoundType = PreferenceManager.getDefaultSharedPreferences(context).getString("round_type", "round_total");
		if(RoundType.equals("round_tip"))
		{
			//Logcelot.log("Settings.isSetToRoundByTip().if(RoundType.equals(\"round_tip\"))");
			return true;
		}
		else
		{
			//Logcelot.log("Settings.isSetToRoundByTip().if(RoundType.equals(\"round_tip\")).else");
			return false;
		}
	}
	
	public static float getExcludeTaxRate(Context context)
	{
		//Logcelot.log("Settings.getExcludeTaxRate()");
		return PreferenceManager.getDefaultSharedPreferences(context).getFloat("exclude_tax", 0);
	}
}
