import logging
import os
import shutil
import itertools
import random

import settings
import time
import re #for re.split
import pandas as pd
from bs4 import BeautifulSoup
from xml.dom import minidom

from utilities import listDirectories

from multiprocessing import Pool
from functools import partial

import xml.etree.ElementTree as ET

def getLocCoveragePercentageFromXML():
    tree = ET.parse("coverage.xml")
    root = tree.getroot()

    locCov = ''
    for coverage in root.iter("coverage"):
        if coverage.attrib['type'] == 'line, %':
            locCov = coverage.attrib['value']
            break

    locCov = locCov[locCov.find('(')+1:-1] # remove initial part
    covered = float(locCov.split('/')[0].replace(',','.'))
    coverable = float(locCov.split('/')[1]) -93 #subtract emma instrumentation locs

    return covered/coverable

def disjoint(lst1, lst2):
    lst3 = [value for value in lst1 if value in lst2] #compute intersection
    return not(bool(lst3))

def analyzeApp(overallSubjects,aut):
    logging.info("%s [%-11s] Analysing coverage unions" % (time.asctime(time.localtime()),aut))

    effortIET = 3
    effortUET = 1
    maxEffort = 20

    maxIETsubsets = 20
    maxUETsubsets = 50

    random.seed(43) #seed values for the five reps: 42, 43, 44, 45, 46

    # create temp folder if necessary
    tempPath = settings.temporaryPath + "\\"  # + str(c)
    if not (os.path.exists(tempPath)):
        os.makedirs(tempPath)

    results = []

    for nIET in range(1,20):
        for nUET in range(1,20):
            if nIET * effortIET + nUET * effortUET > maxEffort:
                continue

            print("%s [%-11s] Computing coverage unions for %d IET and %d UET" % (time.asctime(time.localtime()), aut, nIET, nUET))
            # subsetsIET = list(itertools.combinations(overallSubjects,nIET))
            # subsetsUET = list(itertools.combinations(overallSubjects, nUET))
            subsetsIET = list(itertools.combinations(overallSubjects, nIET))
            subsetsUET = list(itertools.combinations(overallSubjects, nUET))

            random.shuffle(subsetsIET)
            random.shuffle(subsetsUET)

            counterIET = 0
            counterUET = 0

            for subsetIET in subsetsIET:
                subjectsIET = list(subsetIET)
                if counterIET == maxIETsubsets:
                    break;
                counterIET = counterIET+1

                counterUET = 0
                for subsetUET in subsetsUET:
                    subjectsUET = list(subsetUET)
                    if not(disjoint(subjectsIET,subjectsUET)):
                        print("NOT DISJOINT, SKIPPING COMBINATION. %s - %s" % (' '.join(subjectsIET), ' '.join(subjectsUET)))
                        continue

                    if counterUET == maxUETsubsets:
                        break;
                    counterUET = counterUET + 1

                    # prepare system command to run emma
                    unionCommand = "java -cp .\\emma-2.0.5312\\lib\\emma.jar emma merge "

                    for subject in subjectsIET:
                        strategy = "WhiteBox" #IET
                        unionCommand += " -in %s\\%s\\%s\\%s\\coverage.ec " % (
                        settings.coveragePath, aut, subject, strategy)
                    for subject in subjectsUET:
                        strategy = "BlackBox" #UET
                        unionCommand += " -in %s\\%s\\%s\\%s\\coverage.ec " % (
                        settings.coveragePath, aut, subject, strategy)

                    unionCommand += " --out %s\\%s_%dIET_%dUET.es" % (tempPath, aut, nIET, nUET)

                    if os.path.exists("%s\\%s_%dIET_%dUET.es" % (tempPath, aut, nIET, nUET)):
                        os.remove("%s\\%s_%dIET_%dUET.es" % (tempPath, aut, nIET, nUET))

                    print(unionCommand)
                    os.system(unionCommand)

                    # generate txt report
                    # make sure to select the right folder for each aut
                    #reportCommand = "java -jar jacoco\\jacococli.jar report --quiet %s\\%s_%dIET_%dUET.es --classfiles .\\Source_inf\\%s\\app\\build\\intermediates\\javac\\debug\\classes --html %s\\html\\%s_%dIET_%dUET" % (
                    # tempPath, aut, nIET, nUET, aut, tempPath, aut, nIET, nUET)
                    reportCommand = f"java -cp .\\emma-2.0.5312\\lib\\emma.jar emma report -sourcepath .\\Source\\{aut}\src -r xml -in .\\em\\{aut}\\coverage.em,{tempPath}\\{aut}_{nIET}IET_{nUET}UET.es"

                    print(reportCommand)
                    os.system(reportCommand)

                    coverage = getLocCoveragePercentageFromXML()

                    resultsRow = {
                        "aut": aut,
                        "sizeIET": nIET,
                        "sizeUET": nUET,
                        "subjectsIET": '_'.join(subjectsIET),
                        "subjectsUET": '_'.join(subjectsUET),
                        "strategy": "mixed",
                        "coverage": coverage
                    }
                    results.append(resultsRow)
                    print(resultsRow)

            df = pd.DataFrame(results)
            outputDir = settings.resultsPath+"/mix/"
            if not os.path.exists(outputDir):
                os.makedirs(outputDir)
            df.to_csv(outputDir+"%s_%dIET_%dUET_results.csv"%(aut,nIET,nUET),index=False,sep=";")


    

if __name__ == '__main__':

    # clean up temporary data
    if not(os.path.exists(settings.resultsPath)):
        #shutil.rmtree(settings.resultsPath)
        #os.rename(settings.resultsPath, settings.resultsPath+'_backup/')
        os.makedirs(settings.resultsPath)

    # analysis script
    print("Starting Analysis")

    auts = listDirectories(settings.coveragePath)
    print('%s - Detected %d application(s): %s' % (time.asctime(time.localtime()),len(auts),", ".join(auts)))
    subjects = listDirectories(settings.coveragePath + "/" + auts[0]) #assume we have the same subjects for each aut.
    print('%s - Detected %d subject(s): %s' % (time.asctime(time.localtime()),len(subjects),", ".join(subjects)))

    # start parallel processes for analysing the auts
    process = partial(analyzeApp,subjects)
    #with Pool(len(auts)) as pool:
    with Pool(1) as pool:
        pool.map(process, auts)
    
