import logging
import os
import shutil
import itertools
import settings
import time
import re #for re.split
import pandas as pd
from bs4 import BeautifulSoup

from utilities import listDirectories

from multiprocessing import Pool
from functools import partial

def analyzeApp(overallSubjects,aut):
    logging.info("%s [%-11s] Analysing coverage unions" % (time.asctime(time.localtime()),aut))
    for c in settings.cardinalities:
        combinations = list(itertools.combinations(overallSubjects,c))
        #logging.info("[%-11s] Computing coverage unions for %d subsets of %d subjects" % (aut,len(combinations),c))
        print("%s [%-11s] Computing coverage unions for %d subsets of %d subjects" % (time.asctime(time.localtime()),aut,len(combinations),c))
        #logging.info("%d combinations detected for subsets of cardinality %d in a set of %d subjects" % (len(combinations), c, len(subjects) ))
        results = []

        counter = 0
        for subset in combinations:
            subjects = list(subset)
            counter = counter + 1
            if(counter%1000==1):
                print("%s [%-11s] Computing coverage union  for subset %d out of %d" % (time.asctime(time.localtime()),aut,counter,len(combinations)))
            
            #coverage = computeLOCCoverageUnion(aut,list(subset))
            for strategy in ["BlackBox"]: #["WhiteBox", "BlackBox"]: #analyze only BB
                # create folder if necessary
                tempPath = settings.temporaryPath + "\\"# + str(c)
                if not( os.path.exists(tempPath) ):
                    os.makedirs(tempPath)
                
                # prepare system command to run emma
                unionCommand = "java -cp .\emma-2.0.5312\lib\emma.jar emma merge -quiet "
                # unionCommand = "java -jar jacoco\\jacococli.jar merge --quiet "
                # Manuale_inf\MunchLife\ALTIERO\BlackBox\coverage.ec Manuale_inf\MunchLife\FIADONE\BlackBox\coverage.ec --destfile merged.es
                # [INFO] Loading execution data file D:\Starace\GUI Testing\Manuale_inf\MunchLife\ALTIERO\BlackBox\coverage.ec.
                # [INFO] Loading execution data file D:\Starace\GUI Testing\Manuale_inf\MunchLife\FIADONE\BlackBox\coverage.ec.
                # [INFO] Writing execution data to D:\Starace\GUI Testing\merged.es.
                for subject in subjects:
                    unionCommand += " -in "+ settings.coveragePath+ +"\\" + aut + "\\" + subject + "\\" + strategy + "\\" + "coverage.ec"
                    # unionCommand += " %s\\%s\\%s\\%s\\coverage.ec" % (settings.coveragePath, aut, subject, strategy)
                unionCommand += " --out %s\\%s_%d.es" % (tempPath,aut,c)

                if os.path.exists("%s\\%s_%d.es" % (tempPath,aut,c)):
                    os.remove("%s\\%s_%d.es" % (tempPath,aut,c))

                print(unionCommand)
                os.system(unionCommand)

                # generate txt report
                # make sure to select the right folder for each aut
                reportCommand = "java -cp .\\emma-2.0.5312\\lib\\emma.jar emma report -quiet -sourcepath .\\Source_inf\\%s\\app\\src -r txt -Dreport.txt.out.file=%s\\%s_%d.txt -in .\em\%s\coverage.em,%s\\%s_%d.es" % (aut,tempPath,aut,c,aut,tempPath,aut,c)
                #reportCommand = "java -jar jacoco\\jacococli.jar report --quiet %s\\%s_%d.es --classfiles .\\Source_inf\\%s\\app\\build\\intermediates\\javac\\debug\\classes --html %s\\html\\%s_%d" % (tempPath,aut,c,aut,tempPath,aut,c)

                #logging.info(reportCommand)
                #if not( os.path.exists("%s\\%s_%s_%s.txt" % (tempPath,aut,strategy,"_".join(subjects)) ) ):
                if os.path.exists("%s\\html\\%s_%d" % (tempPath,aut,c)) :
                    shutil.rmtree("%s\\html\\%s_%d" % (tempPath,aut,c))
                print(reportCommand)
                os.system(reportCommand)

                with open("%s\\html\\%s_%d\\index.html" % (tempPath,aut,c)) as htmlReport:
                    html = BeautifulSoup(htmlReport,"html.parser")
                    #get coverage value from html file
                    missedInstructionsElement = html.select_one("tfoot tr td:nth-child(2)")
                    missedInstructions = missedInstructionsElement.getText() #will be of the form %d of %d
                    missed = int(missedInstructions.split(" of ")[0].replace('.',''))
                    total  = int(missedInstructions.split(" of ")[1].replace('.',''))
                    covered = total - missed
                    coverage = (covered * 100 / total)
                    print("Missed: %d, Covered: %d, Total: %d, coverage: %f" % (missed, covered, total, coverage))



                # with open("%s\\%s_%d.txt" % (tempPath, aut, c) ) as txtReport:
                #     for _ in range(5):
                #         txtReport.readline(); #skip first five lines
                #     overallCoverage = txtReport.readline()
                #     txtReport.close()
                #     LOCData = re.split('\t',overallCoverage)[3]
                #     coveredLOC = re.split('/|\(|\)', LOCData)[1]
                #     totalLOC   = re.split('/|\(|\)', LOCData)[2]
                #     coveredLOC = float(coveredLOC.replace(',','.'))
                #     totalLOC = float(totalLOC.replace(',','.'))
                #     totalLOC -= settings.emmaInstrumentLOCs #remove emma instrumentations locs
                #     coverage = coveredLOC/totalLOC
        
                resultsRow = {
                    "aut": aut,
                    "size": c,
                    "subset": '_'.join(subjects),
                    "strategy": strategy,
                    "coverage": coverage
                } 
                results.append(resultsRow)
        df = pd.DataFrame(results)
        outputDir = settings.resultsPath+"/"+str(c)+"/"
        if not os.path.exists(outputDir):
            os.makedirs(outputDir)
        df.to_csv(outputDir+"%s_results.csv"%aut,index=False,sep=";")
        print("%s [%-11s] Done computing %d coverage unions for subsets of size %d" % (time.asctime(time.localtime()),aut,len(combinations),c))

    

if __name__ == '__main__':

    logging.basicConfig(
        level=logging.INFO,
        format="%(asctime)s [%(levelname)s] %(message)s",
        handlers=[
            logging.FileHandler("debug.log"),
            logging.StreamHandler()
        ]
    )

    # clean up temporary data
    if not(os.path.exists(settings.resultsPath)):
        #shutil.rmtree(settings.resultsPath)
        #os.rename(settings.resultsPath, settings.resultsPath+'_backup/')
        os.makedirs(settings.resultsPath)

    # analysis script
    print("Starting Analysis")

    auts = listDirectories(settings.coveragePath)
    print('%s - Detected %d application(s): %s' % (time.asctime(time.localtime()),len(auts),", ".join(auts)))
    subjects = listDirectories(settings.coveragePath + "/" + auts[0]) #assume we have the same subjects for each aut.
    print('%s - Detected %d subject(s): %s' % (time.asctime(time.localtime()),len(subjects),", ".join(subjects)))

    # start parallel processes for analysing the auts
    process = partial(analyzeApp,subjects)
    with Pool(len(auts)) as pool:
        pool.map(process, auts)
    
