#! /usr/bin/python3
import argparse
import os

argparser = argparse.ArgumentParser(description='Run update synthesis benchmarks.')

argparser.add_argument('test_path', type=str, help='path to the test json.')
argparser.add_argument('kaki_path', type=str, help='the path to Kaki.jar')
argparser.add_argument('-o', metavar='output_path', type=str, help='the output path of the raw data from the methods', default='output')
argparser.add_argument('-ta', metavar='kaki_arguments', type=str, default='')

subparser = argparser.add_subparsers(title='method', dest='method', help='Choose to run FLIP or Kaki')
flip_parser = subparser.add_parser('flip', help='Run benchmarks with flip')

kaki_parser = subparser.add_parser('kaki', help='Run benchmarks with kaki')
kaki_parser.add_argument('-e', '--engine', metavar='verifypn_games_path', type=str, help='the path to the verifypn-games engine')

args = argparser.parse_args()

out_dir = f'{args.o}/{os.path.dirname(args.test_path)}'

try:
    os.makedirs(out_dir)
except:
    pass

if args.method == 'kaki':
    os.system(f'(time -p java -jar {args.kaki_path} {args.engine} {args.test_path} {args.ta} -O -V Low) >> {args.o}/{args.test_path}.txt 2>&1')

elif args.method == 'flip':
    subpaths_path = args.o + '/' + args.test_path + '.subpaths'
    os.chdir(os.path.abspath("flip"))
    os.system(f'(time -p java -jar ../{args.kaki_path} _ ../{args.test_path} -f ../{subpaths_path}; python2 ../runflipwithdfa.py ../{args.test_path} ../{subpaths_path}) >> ../{args.o}/{args.test_path}.txt 2>&1')

elif args.method == 'netstack':
    os.system(f'time -p "./netstack/run_problem.sh " >>')

else:
    print("ERROR: invalid method!")
