#! /usr/bin/python3
import argparse
import os

argparser = argparse.ArgumentParser(description='Run update synthesis benchmarks.')

argparser.add_argument('-ex', metavar='executor', type=str, help='Executor for problems (e.g. sbatch for slurm), leave empty if not applicable', default='')
argparser.add_argument('benchmark_path', type=str, help='path to the root directory containing the test files.')
argparser.add_argument('-k', metavar='Kaki path', type=str, help='the path to Kaki.jar', default='Kaki.jar')
argparser.add_argument('-o', metavar='output_path', type=str, help='the output path of the raw data from the methods', default='output')
argparser.add_argument('-vg', metavar='verifypn-games', type=str, help='Path to verifypn-games engine', default='verifypn-linux64')
argparser.add_argument('-to', metavar='Timeout (s)', type=int, help='Timeout in seconds for each problem', default=60)

subparser = argparser.add_subparsers(title='method', required=True, dest='method', help='Choose to run flip, kaki or netstack')
flip_parser = subparser.add_parser('flip', help='Run benchmarks with FLIP')
netstack_parser = subparser.add_parser('netstack', help='Run benchmark with Netstack')

kaki_parser = subparser.add_parser('kaki', help='Run benchmarks with Kaki')
kaki_parser.add_argument('-n', metavar='name', type=str, default='kaki')
argparser.add_argument('-ta', metavar='kaki args', type=str, default='')

args = argparser.parse_args()

if not os.path.exists(args.vg):
    print(f'verifypn-games not found at {os.path.abspath(args.vg)}')
    exit(-1)

if args.method == 'kaki':
    def launchjob(dir: str, file: str, args):
        fpath = os.path.join(dir, f)
        os.system(f'timeout {args.to}s {args.ex} ./run_test.py {fpath} {args.k} -ta "{args.ta}" -o {args.o}/{args.n} kaki -e verifypn-linux64')

elif args.method == 'flip':
    def launchjob(dir: str, file: str, args):
        fpath = os.path.join(dir, f)
        os.system(f'timeout {args.to}s {args.ex} ./run_test.py {fpath} {args.k} -o {args.o}/flip flip')

elif args.method == 'netstack':
    def launchjob(indir: str, file: str, args):
        curr_dir = os.path.abspath(os.getcwd())
        topo_folder = os.path.basename(os.path.normpath(dir))
        out_dir = f'{args.o}/netstack/data/{topo_folder}'
        prob_name = file.removesuffix('.json')
        
        try:
            os.makedirs(out_dir)
        except:
            pass

        os.chdir(os.path.abspath("netstack"))
        os.system(f'timeout {args.to}s {args.ex} ./scripts/timeit.sh "./run_problem.sh {curr_dir}/{indir} {curr_dir}/{out_dir} {file}" "{curr_dir}/{out_dir}/{prob_name}.txt"')
        os.chdir('..')

for dir, dnames, fnames in os.walk(args.benchmark_path):
    for f in fnames:
        if f.endswith('.json'):
            print("Running ", os.path.join(dir, f))
            launchjob(dir, f, args)
      
      
      
