#!/bin/bash
#./solve_simple.sh

if [ $(ls data/simple_results/ | wc -l) != 6 ]; then
    echo "## Result files missing!";
    exit 1
fi

echo "## Checking results (if no lines are printed below, the results are ok) ##"
# all examples must contain a result
grep -L "END Pareto-frontier" data/simple_results/*.stackelberg_*

# 4node and 7node are solvable -> must contain a solution with a loosing attacker
grep -L "attacker cost: 2147483647" data/simple_results/4node.stackelberg_*
grep -L "attacker cost: 2147483647" data/simple_results/7node.stackelberg_*

# check maximum steps necessary
grep -L "fix ops costs: 3, attacker cost: 2147483647" data/simple_results/4node.stackelberg_*
grep -L "fix ops costs: 6, attacker cost: 2147483647" data/simple_results/7node.stackelberg_seq
grep -L "fix ops costs: 3, attacker cost: 2147483647" data/simple_results/7node.stackelberg_cc

# 5node not solvable -> must not contain a solution with a loosing attacker 
grep -l "attacker cost: 2147483647" data/simple_results/5node.stackelberg_*

# 4node: following switch order necessary: s2, s3, s1
grep -zL "attacker cost: 2147483647.*fix_switch t0 s2" data/simple_results/4node.stackelberg_*
grep -zL "attacker cost: 2147483647.*fix_switch t1 s3" data/simple_results/4node.stackelberg_*
grep -zL "attacker cost: 2147483647.*fix_switch t2 s1" data/simple_results/4node.stackelberg_*

# 7node: following two switch orders necessary: first order: s5, .*, s6; second order: s2, .*, s3, .*, s1
grep -zL "attacker cost: 2147483647.*fix_switch .. s2.*fix_switch .. s3.*fix_switch .. s1" data/simple_results/7node.stackelberg_seq
grep -zL "attacker cost: 2147483647.*fix_switch .. s5.*fix_switch .. s6" data/simple_results/7node.stackelberg_seq
grep -zL "attacker cost: 2147483647.*fix_switch .. s2.*fix_next-step.*fix_switch .. s3.*fix_next-step.*fix_switch .. s1" data/simple_results/7node.stackelberg_cc
grep -zL "attacker cost: 2147483647.*fix_switch .. s5.*fix_next-step.*fix_switch .. s6" data/simple_results/7node.stackelberg_cc

exit 0
