#!/bin/bash
data_path="$(pwd)/$1"
results_path="$(pwd)/$2"
domain="$3"

mkdir -p "$results_path"

bin="python2 $(pwd)/stackelberg-planner-sls/fast-downward.py"
runname="stackelberg_$domain"

echo "$data_path $results_path"

if [ -z "$data_path" ] ; then
	echo "No data path set"
	exit
fi

if [ -z "$results_path" ] ; then
	echo "No result path set"
	exit
fi

for raw in $data_path/*.pddl
do
	echo "Running $raw"
	b=$(basename $raw)
	file=${b%.pddl}
	$EXECUTOR scripts/executor_tmpdir.sh "$bin $data_path/../../pddl-domains/domain-$domain.pddl $data_path/$file.pddl --search sym_stackelberg(optimal_engine=symbolic(plan_reuse_minimal_task_upper_bound=true,plan_reuse_upper_bound=true),upper_bound_pruning=false,min_relevant_follower_cost=100000)" "$results_path/${file}.$runname"
done

