#!/bin/bash
data_path="$(pwd)/$1"
results_path="$(pwd)/$2"

mkdir -p "$results_path"

bin="$(pwd)/snowcap/snowcap_main"
runname="snowcap"

echo "$data_path $results_path"

if [ -z "$data_path" ] ; then
	echo "No data path set"
	exit
fi

if [ -z "$results_path" ] ; then
	echo "No result path set"
	exit
fi

export RUST_LOG=info

for raw in $data_path/*.json
do
	echo "Running $raw"
	b=$(basename $raw)
	file=${b%.json}
	$EXECUTOR scripts/executor_tmpdir.sh "$bin synthesize custom $data_path/$file.json" "$results_path/${file}.$runname"
done

