#!/bin/bash
data_path="$1"

if [ -z "$data_path" ] ; then
	echo "No data path prefix given";
	echo "Example: $0 data/simple";
	exit
fi

mkdir -p ${data_path}_pddl

for infile in ${data_path}_json/*.json
do
	echo "Converting $infile"
	b=$(basename $infile)
	pddlfile=${data_path}_pddl/${b%.json}.pddl
    logfile=${data_path}_pddl/${b%.json}.log
    python3 pddl-problem-generator/generate_problem.py "$infile" "$pddlfile" > "$logfile" 2>&1
done
