#!/bin/bash
printf "#test"
for b in ${@:5} ; do 
	printf ",$b-time,$b-mem,$b-steps,$b-combinedsteps"
done

printf '\n'

for f in $(ls $1 | grep -v "\.csv$" | grep -oP ".+(?=\.)" | grep -v "verifypn" | sort | uniq | grep -P "$2" | grep -v "$3" | grep -v "$4" ) ; do 
printf "$f"
for b in ${@:5} ; do 
	R="3600000,120000000,,"
	ok=""
	steps="" # no result within time/mem limits
	combinedsteps=""
	if [ "$b" == "netsynth" ] ; then
		ok=$(grep "finished synthesizing" $1/$f.$b )
	elif [[ "$b" == stackelberg_* ]] ; then
		ok=$(grep "END Pareto-frontier" $1/$f.$b )
		if [ ! -z "$ok" ] ; then
			steps=$(grep -oP "(?<=fix ops costs: ).*(?=, attacker cost: 2147483647)" $1/$f.$b)
			if [ $? -ne 0 ]; then
				steps="" # result found, but no valid solution found
				combinedsteps=""
			elif [ "$b" == "stackelberg_seq" ]; then
				combinedsteps="$steps"
				logfile="${1/_results/_pddl}/$f.log"				
				before=$(grep "Switch Before: s" $logfile | grep -o "[ ,]s" | wc -l)
				steps=$(echo "$steps+$before" | bc -l)
				if [ $before -ne 0 ]; then
					combinedsteps=$(echo "$combinedsteps+1" | bc -l)
				fi
				after=$(grep "Switch After: s" $logfile | grep -o "[ ,]s" | wc -l)
				steps=$(echo "$steps+$after" | bc -l)
				if [ $after -ne 0 ]; then
					combinedsteps=$(echo "$combinedsteps+1" | bc -l)
				fi
			else
				combinedsteps="$steps"
			fi
		fi
	elif [ "$b" == "snowcap" ] ; then
		ok=$(grep "Update sequence:\|Error: ProbablyNoSafeOrdering" $1/$f.$b )
	else
		ok=$(grep "Query is" $1/$f.$b )
	fi
	if [ ! -z "$ok" ] ; then
		t=$(grep -oP "(?<=@@@T).*(?=@@@)" $1/$f.$b)
		m=$(grep -oP "(?<=@@@M).*(?=@@@)" $1/$f.$b)
		R="$t,$m,$steps,$combinedsteps"
	fi
	printf ",$R"
done
printf '\n'
done
