#!/bin/bash
#SBATCH --mail-type=FAIL
#SBATCH --mem=26000
#SBATCH --time=1:00:00
#SBATCH --error=/dev/null
#SBATCH --output=/dev/null
#SBATCH --cpus-per-task=4
#SBATCH --partition=dhabi
#SBATCH --exclude=naples[01-03]

if [ -z "$MEMORY" ] ; then
    MEMORY=$((25*1024*1024))
fi

if [ -z "$TIME" ] ; then
    TIME="3600"
fi

ulimit -v $MEMORY

tmp_dir=$(mktemp -d -t mp02ss-tmp-XXXXXXXXXX)
cd $tmp_dir

echo "Running\n \"$1\" &> $2"
START=$(date +%s%N | cut -b1-13)
R=$($1)
END=$(date +%s%N | cut -b1-13)
echo "$R" > $2
T=$(echo "$END-$START" | bc -l)
echo "@@@T$T@@@" >> $2
echo "Done!"

cd ..
rm -rf $tmp_dir
