#!/bin/bash

mkdir -p plots

B=$(basename $4 )
OUT=${B%.csv}
OUT="plots/cactus-$OUT-steps.pdf"
PLOT="
set xlabel \"Instances\"
set ylabel \"Rounds\"
set logscale y 10
set yrange [$2:$3]
set xrange [:$5]
set terminal pdf enhanced color dashed lw 1  size 5.1,2.7
set output '$OUT'
set key top left

set datafile separator ','
plot '< sort -gk12 -t , $4' using (\$12) with lines dashtype 3 linetype 6 linewidth 3 title \"Sequential\", \
     '< sort -gk13 -t , $4' using (\$13) with lines dashtype 2 linetype 7 linewidth 3 title \"Optimized\", \
     '< sort -gk17 -t , $4' using (\$17) with lines dashtype 1 linetype 8 linewidth 3 title \"Concurrent\""

echo "$PLOT" | gnuplot

