#!/bin/bash

mkdir -p plots

B=$(basename $4 )
OUT=${B%.csv}
OUT="plots/scatter-$OUT.pdf"
PLOT="
set xlabel \"Seconds_{Seq}\"
set ylabel \"Seconds_{CC}\"
set logscale x 10
set logscale y 10
set yrange [:$3]
set xrange [:$5]
set terminal pdf enhanced color dashed lw 1  size 5.1,2.7
set output '$OUT'
set key off

set datafile separator ','
plot '$4' using (\$10/1000):(\$14/1000):(\$10>=3600000 || \$14>=3600000 ? 2 : 1):(\$10>=3600000 ? (\$14>=3600000 ? 0 : 7) : (\$14>=3600000 ? 6 : 8)) with points pt variable linecolor variable title \"Stackelberg\""

echo "$PLOT" | gnuplot

