#!/bin/bash

mkdir -p plots

B=$(basename $4 )
OUT=${B%.csv}
OUT="plots/cactus-$OUT.pdf"
PLOT="
set xlabel \"Instances\"
set ylabel \"Seconds\"
set logscale y 10
set yrange [$2:$3]
set xrange [:$5]
set terminal pdf enhanced color dashed lw 1  size 5.1,2.7
set output '$OUT'
set key top left

set datafile separator ','
plot '< sort -gk2 -t , $4' using (\$2>=3600000 ? \$2 : (\$2/1000)) with lines dashtype 4 linetype 5 linewidth 3 title \"NetSynth\", \
     '< sort -gk6 -t , $4' using (\$6>=3600000 ? \$6 : (\$6/1000)) with lines dashtype 3 linetype 6 linewidth 3 title \"TAPAAL\", \
     '< sort -gk10 -t , $4' using (\$10>=3600000 ? \$10 : (\$10/1000)) with lines dashtype 2 linetype 7 linewidth 3 title \"Stackelberg_{Seq}\", \
     '< sort -gk14 -t , $4' using (\$14>=3600000 ? \$14 : (\$14/1000)) with lines dashtype 1 linetype 8 linewidth 3 title \"Stackelberg_{Cc}\", \
     '< sort -gk18 -t , $4' using (\$18>=3600000 ? \$18 : (\$18/1000)) with lines dashtype 5 linetype 4 linewidth 3 title \"Snowcap\""

echo "$PLOT" | gnuplot

