#!/bin/bash

mkdir -p plots

B=$(basename $4)
OUT=${B%.csv}
OUT="plots/cactus-$OUT-mem.pdf"
PLOT="
set xlabel \"Instances\"
set ylabel \"Megabytes\"
set logscale y 10
set yrange [$2:$3]
set xrange [:$5]
set terminal pdf enhanced color dashed lw 1  size 5.1,2.7
set output '$OUT'
set key top left

set datafile separator ','
plot '< sort -gk3 -t , $4' using (\$2>=3600000 ? \$3 : (\$3/1024)) with lines dashtype 4 linetype 5 linewidth 3 title \"NetSynth\", \
     '< sort -gk7 -t , $4' using (\$6>=3600000 ? \$7 : (\$7/1024)) with lines dashtype 3 linetype 6 linewidth 3 title \"TAPAAL\", \
     '< sort -gk11 -t , $4' using (\$10>=3600000 ? \$11 : (\$11/1024)) with lines dashtype 2 linetype 7 linewidth 3 title \"Stackelberg_{Seq}\", \
     '< sort -gk15 -t , $4' using (\$14>=3600000 ? \$15 : (\$15/1024)) with lines dashtype 1 linetype 8 linewidth 3 title \"Stackelberg_{Cc}\", \
     '< sort -gk19 -t , $4' using (\$18>=3600000 ? \$19 : (\$19/1024)) with lines dashtype 5 linetype 4 linewidth 3 title \"Snowcap\""

echo "$PLOT" | gnuplot

