INDIR="$1"
OUTDIR="$2"
FILEJSON="$3"

filename=${FILEJSON%.json}

infile=${INDIR}/${FILEJSON}
pddlfile=${OUTDIR}/${filename}.pddl
logfile=${OUTDIR}/${filename}.log
outfile=${OUTDIR}/${filename}.txt

python3 pddl-problem-generator/generate_problem.py "$infile" "$pddlfile" > "$logfile" 2>&1

bin="python2 $(pwd)/stackelberg-planner-sls/fast-downward.py"

./scripts/executor_tmpdir.sh "$bin $(pwd)/pddl-domains/domain-cc.pddl $pddlfile --search sym_stackelberg(optimal_engine=symbolic(plan_reuse_minimal_task_upper_bound=true,plan_reuse_upper_bound=true),upper_bound_pruning=false,min_relevant_follower_cost=100000)" "$outfile"
