from utils import Network as net
from utils import Output

def generatePddl(network: net.Network, stepCount: int):
    out = ""

    steps = ["t" + str(step) for step in range(0, stepCount + 1)]

    # generate header
    out += "(define (problem netupdate-problem) (:domain netupdate)\n"

    # generate objects
    out += "(:objects\n"
    # dead-end switches
    out += "    sxx - t-switch-deadend\n"
    if len(network.switchesDeadEnd) > 0:
        out += "    " + Output.formatSet(network.switchesDeadEnd, "s") + " - t-switch-deadend\n"
    # normal (changing, but not first or last) switches
    if len(network.switchesNormal) > 0:
        out += "    " + Output.formatSet(network.switchesNormal, "s") + " - t-switch-normal\n"
    # steps
    out += "    " + " ".join(steps) + " - t-timestep\n"
    # the packet
    out += "    p1 - t-packet\n"
    # the booleans
    out += "    bAttackerGoal - t-is-goal-reached\n"
    out += "    bTimestepChoosePending - t-is-timestep-chosen\n"
    out += "    bLastStepDone - t-is-last-step-done\n"
    out += ")\n\n"

    # initialize cost
    out += "(:init\n"
    out += "    (= (total-cost) 0)\n"

    # setup steps
    out += "    (first-step t0)\n"
    out += "    (current-step t0)\n"
    for stepPair in zip(steps[:-1], steps[1:]):
        out += f"    (step-direct-after {stepPair[0]} {stepPair[1]})\n"
    for i in range(len(steps) - 1):
        for j in range(i + 1, len(steps)):
            out += f"    (step-after {steps[i]} {steps[j]})\n"

    # output routing maps
    def outputRoutingMap(routing: net.Network.Routing, postfix: str):
        ret = ""
        for route in sorted(routing.initial.items()):
            ret += f"    (link-before{postfix} s{route[0]} s{route[1]})\n"
        for route in sorted(routing.final.items()):
            ret += f"    (link-after{postfix} s{route[0]} s{route[1]})\n"
        return ret
    out += outputRoutingMap(network.routing, "")
    out += outputRoutingMap(network.routingBefore, "-b")
    out += outputRoutingMap(network.routingIntermediate, "-i")
    out += outputRoutingMap(network.routingAfter, "-a")
    out += outputRoutingMap(network.routingSingle, "-s")

    # setup packet
    out += f"    (packet-at p1 s{network.nodeStart})\n"
    out += f"    (packet-touched p1 s{network.nodeStart})\n"
    out += f"    (packet-target p1 s{network.nodeFinal})\n"

    # setup waypoints
    for waypoint in sorted(network.nodesWaypoint.difference([network.nodeFinal])):
        out += f"    (packet-waypoint p1 s{waypoint})\n"

    # set initial boolean values
    out += "    (timestep-choose-pending bTimestepChoosePending)\n"
    out += ")\n\n"

    # setup goal
    out += "(:goal (and\n"
    out += "        (attacker-goal-reached bAttackerGoal)\n"
    out += "    )\n"
    out += ")\n\n"

    # setup metric
    out += "(:metric\n"
    out += "    minimize (total-cost)\n"
    out += "))\n"

    return out
