from utils import Network as net

# finds the non-changing switches and generates a fixed routing map
def generateFixedRouting(network: net.Network):
    network.routing.fixed = {source: target for source, target in network.routing.initial.items() if network.routing.final.get(source) == target}

# generates the sets of switches from the current routing maps
def generateSwitchSets(network: net.Network):
    network.switchesNotChanging = set(network.routing.fixed.keys())

    # for the following sets non changing switches will be ignored

    # changing switches: union of initial and final routing maps sources
    network.switchesChanging = {*network.routing.initial.keys(), *network.routing.final.keys()}

    # dead-end switches: union of initial and final routing maps targets which are not in switchesChanging
    network.switchesDeadEnd = {*network.routing.initial.values(), *network.routing.final.values()}.difference(network.switchesChanging)

    # first|last switches: changing switches which are not in both routing maps
    if not network.firstLastConvertedToFixed:
        network.switchesFirst = {source for source in network.switchesChanging if network.routing.initial.get(source) == None}
        network.switchesLast = {source for source in network.switchesChanging if network.routing.final.get(source) == None}

    # normal switches: all changing switches which are not first or last
    network.switchesNormal = network.switchesChanging.difference(network.switchesFirst).difference(network.switchesLast)

    # all switches: set.union(network.switchesChanging, network.switchesNotChanging, network.switchesDeadEnd)

def checkNodeConsistency(network: net.Network):
    switchesFirstLast = set.union(network.switchesFirst, network.switchesLast)

    if not network.nodeStart in network.switchesChanging:
        raise ValueError(f"StartNode {network.nodeStart} unknown")
    
    if not network.nodeFinal in network.switchesChanging and not network.nodeFinal in network.switchesDeadEnd:
        raise ValueError(f"FinalNode {network.nodeFinal} unknown")

    if network.nodeFinal in switchesFirstLast:
        raise ValueError(f"FinalNode {network.nodeFinal} must not be first or last switch")

    for waypoint in network.nodesWaypoint:
        if not waypoint in network.switchesChanging and not waypoint in network.switchesDeadEnd:
            raise ValueError(f"Waypoint {waypoint} unknown")
        if waypoint in switchesFirstLast:
            raise ValueError(f"Waypoint {waypoint} must not be first or last switch")
