(define (domain netupdate)
    (:requirements :strips :negative-preconditions :typing :action-costs)

    (:types
        t-switch t-timestep t-packet t-boolean - object

        t-switch-deadend - t-switch
        t-switch-no-deadend - t-switch
        t-switch-normal - t-switch-no-deadend

        t-is-goal-reached - t-boolean
        t-is-timestep-chosen - t-boolean

        ; for solving concurrent problems
        t-is-last-step-done - t-boolean
    )

    (:predicates
        (switched ?sw - t-switch-no-deadend)

        (step-direct-after ?t-before ?t-after - t-timestep)
        (step-after ?t-before ?t-after - t-timestep)
        (current-step ?t - t-timestep)
        (at-step ?t - t-timestep ?sw - t-switch-no-deadend)
        (chosen-step ?t - t-timestep)

        (link-before-b ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-after-b ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-before-i ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-after-i ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-before-a ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-after-a ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-before-s ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link-after-s ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        (link ?sw-from - t-switch-no-deadend ?sw-to - t-switch)

        (packet-at ?p - t-packet ?sw - t-switch)
        (packet-touched ?p - t-packet ?sw - t-switch)
        (packet-target ?p - t-packet ?sw - t-switch)
        (packet-waypoint ?p - t-packet ?sw - t-switch)

        (attacker-goal-reached ?b - t-is-goal-reached)
        
        (timestep-choose-pending ?b - t-is-timestep-chosen)

        ; for solving concurrent problems
        (last-step-done ?b - t-is-last-step-done)
        (last-step ?t - t-timestep)
        (first-step ?t - t-timestep)
    )

    (:functions
        (total-cost)
    )

    ; Fix actions -> creates all permutations of switch <-> timestap matchings

    ; switch a switch in current timestep
    (:action fix_switch
        :parameters (?t - t-timestep ?sw - t-switch-normal ?b-last - t-is-last-step-done)
        :precondition (and (not (switched ?sw)) (current-step ?t) (not (last-step-done ?b-last)) )
        :effect (and (switched ?sw) (at-step ?t ?sw))
    )

    ; advance to next timestep
    (:action fix_next-step
        :parameters (?t-prev ?t-next - t-timestep ?b-last - t-is-last-step-done)
        :precondition (and (current-step ?t-prev) (step-direct-after ?t-prev ?t-next) (not (last-step-done ?b-last)) )
        :effect (and (increase (total-cost) 1) (not (current-step ?t-prev)) (current-step ?t-next))
    )

    ; select this timestep as last timestep and finish fix actions
    (:action fix_last-step
        :parameters (?t - t-timestep ?b-last - t-is-last-step-done)
        :precondition (and (current-step ?t) (not (last-step-done ?b-last)))
        :effect (and (increase (total-cost) 1) (last-step ?t) (last-step-done ?b-last))
    )


    ; Attacks: Check that fix did all required actions

    ; all normal switches must be switched
    (:action attack_notallswitched
        :parameters (?sw - t-switch-normal ?b - t-is-goal-reached)
        :precondition (not (switched ?sw))
        :effect (and (increase (total-cost) 1) (attacker-goal-reached ?b))
    )

    ; last step must be done
    (:action attack_laststepmissing
        :parameters (?b-last - t-is-last-step-done ?b - t-is-goal-reached)
        :precondition (not (last-step-done ?b-last))
        :effect (and (increase (total-cost) 1) (attacker-goal-reached ?b))
    )


    ; Choose the attack timestep

    (:action attack_choose-timestep
        :parameters (?t - t-timestep ?b - t-is-timestep-chosen)
        :precondition (timestep-choose-pending ?b)
        :effect (and (increase (total-cost) 1) (chosen-step ?t) (not(timestep-choose-pending ?b)))
    )


    ; Add links for normal switches

    ; switch switches at current step; choose that it already switched
    (:action attack_addlink-current-before-b
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and 
            (chosen-step ?t-chosen)
            (first-step ?t-chosen)
            (not (last-step ?t-chosen))
            (link-after-b ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
            
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it did not switch yet
    (:action attack_addlink-current-after-b
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (first-step ?t-chosen)
            (not (last-step ?t-chosen))
            (link-before-b ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches after the current step
    (:action attack_addlink-after-b
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (first-step ?t-chosen)
            (not (last-step ?t-chosen))
            (link-before-b ?sw-from ?sw-to)
            (not (at-step ?t-chosen ?sw-from))
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switched before current step
    (:action attack_addlink-before-i
        :parameters (?p - t-packet ?t-chosen - t-timestep ?t-before - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (not (last-step ?t-chosen))
            (link-after-i ?sw-from ?sw-to)
            (at-step ?t-before ?sw-from)
            (not (at-step ?t-chosen ?sw-from))
            (step-after ?t-before ?t-chosen)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it already switched
    (:action attack_addlink-current-before-i
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and 
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (not (last-step ?t-chosen))
            (link-after-i ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it did not switch yet
    (:action attack_addlink-current-after-i
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (not (last-step ?t-chosen))
            (link-before-i ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches after the current step
    (:action attack_addlink-after-i
        :parameters (?p - t-packet ?t-chosen - t-timestep ?t-after - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (not (last-step ?t-chosen))
            (link-before-i ?sw-from ?sw-to)
            (at-step ?t-after ?sw-from)
            (step-after ?t-chosen ?t-after)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it already switched
    (:action attack_addlink-current-before-s
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and 
            (chosen-step ?t-chosen)
            (first-step ?t-chosen)
            (last-step ?t-chosen)
            (link-after-s ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it did not switch yet
    (:action attack_addlink-current-after-s
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (first-step ?t-chosen)
            (last-step ?t-chosen)
            (link-before-s ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switched before current step
    (:action attack_addlink-before-a
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (last-step ?t-chosen)
            (link-after-a ?sw-from ?sw-to)
            (not (at-step ?t-chosen ?sw-from))
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it already switched
    (:action attack_addlink-current-before-a
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and 
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (last-step ?t-chosen)
            (link-after-a ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )

    ; switch switches at current step; choose that it did not switch yet
    (:action attack_addlink-current-after-a
        :parameters (?p - t-packet ?t-chosen - t-timestep ?sw-from - t-switch-normal ?sw-to - t-switch)
        :precondition (and
            (chosen-step ?t-chosen)
            (not (first-step ?t-chosen))
            (last-step ?t-chosen)
            (link-before-a ?sw-from ?sw-to)
            (at-step ?t-chosen ?sw-from)
        )
        :effect (and (link ?sw-from ?sw-to) )
    )


    ; Packet movement

    ; normal packet movement
    (:action attack_movepacket
        :parameters (?p - t-packet ?sw-from ?sw-to - t-switch-no-deadend)
        :precondition (and
            (link ?sw-from ?sw-to)
            (packet-at ?p ?sw-from)
            (not (packet-target ?p ?sw-to))
            (not (packet-touched ?p ?sw-to))
        )
        :effect (and (increase (total-cost) 1) (packet-at ?p ?sw-to) (packet-touched ?p ?sw-to) (not (packet-at ?p ?sw-from)))
    )

    ; detected loop -> attacker wins
    (:action attack_movepacket-retouch-loop
        :parameters (?p - t-packet ?sw-from ?sw-to - t-switch-no-deadend ?b - t-is-goal-reached)
        :precondition (and
            (link ?sw-from ?sw-to)
            (packet-at ?p ?sw-from)
            (not (packet-target ?p ?sw-to))
            (packet-touched ?p ?sw-to)
        )
        :effect (and (increase (total-cost) 1) (attacker-goal-reached ?b))
    )

    ; packet reached target -> attacker lost (no more actions)
    (:action attack_movepacket-target
        :parameters (?p - t-packet ?sw-from - t-switch-no-deadend ?sw-to - t-switch)
        :precondition (and
            (link ?sw-from ?sw-to)
            (packet-at ?p ?sw-from)
            (packet-target ?p ?sw-to)
            (not (packet-touched ?p ?sw-to))
        )
        :effect (and (increase (total-cost) 0) (packet-touched ?p ?sw-to) (not (packet-at ?p ?sw-from)))
    )

    ; packet reached target, but missed waypoint -> attacker wins
    (:action attack_movepacket-target-waypoint-missed
        :parameters (?p - t-packet ?sw-from - t-switch-no-deadend ?sw-to ?sw-wp - t-switch ?b - t-is-goal-reached)
        :precondition (and
            (link ?sw-from ?sw-to)
            (packet-at ?p ?sw-from)
            (packet-target ?p ?sw-to)
            (packet-waypoint ?p ?sw-wp)
            (not (packet-touched ?p ?sw-to))
            (not (packet-touched ?p ?sw-wp))
        )
        :effect (and (increase (total-cost) 1) (attacker-goal-reached ?b))
    )

    ; packet reached (non-target) deadend -> attacker wins
    (:action attack_movepacket-deadend
        :parameters (?p - t-packet ?sw-from - t-switch-no-deadend ?sw-to - t-switch-deadend ?b - t-is-goal-reached)
        :precondition (and
            (link ?sw-from ?sw-to)
            (packet-at ?p ?sw-from)
            (not (packet-target ?p ?sw-to))
        )
        :effect (and (increase (total-cost) 1) (attacker-goal-reached ?b))
    )
)
