This archive contains the NetStack tool and experiments for the paper:
S. Schmid, B. C. Schrenk and A. Torralba, "NetStack: A Game Approach to Synthesizing Consistent Network Updates," in Proc. IFIP Networking. IEEE, 2022.

# Requirements
The experiments can be run under Ubuntu 20.04 on x86_64. Following packages must be installed:
`build-essential cmake g++ git make python3 gcc-multilib g++-multilib automake flex bison python2 gnuplot bc time libfl-dev`

## Container
For easy use a Dockerfile and a DevContainer configuration file for Visual Studio Code are provided in the folder `.devcontainer`.

## Original Experiments Evnironment
The experiments were run on a cluster of AMD EPYC 7551 CPUs using Slurm Workload Manager. Hyperthreading was disabled, the time was limited to 1 hour and the memory to 7 GB.

Following envioronment was used:
```sh
unset TIME
export MEMORY=7340032
export EXECUTOR=sbatch
```

# Content
The archive contains all scripts, sources and binaries to reproduce the results. It also contains already all results of the experiments.

| Path | Description |
|------|-------------|
| `pddl-domains` | Models of the network update problem as Stackelberg planning domains
| `pddl-problem-generator` | The tool to generate planning problems out of topology zoo descriptions
| `stackelberg-planner-sls` | The binaries and sources of the used planning tool
| `data/*_json` | The topology zoo description files
| `data/*_pddl` | The generated planning problem files
| `data/*_results` | The result files of the various planning tools
| `data/*_results/*.stackelberg_[seq\|cc]` | The results of the stackelberg model
| `scripts` | Helper scripts
| `csvs` | Collected experiment result data (timing, memory, batch counts)
| `plots` | Generated plots of result data as used in thesis

## Stackelberg-Planner-SLS
The network update problem models are solved using the Stackelberg planning tool provided by Prof. Dr. Álvaro Torralba. Sources and binaries of the used planning tool are included in this archive. The sources are from https://gitlab.com/atorralba_planners/stackelberg-planner-sls/ with the commit hash 58447538e7a3987be44ca12ea4d74e8dc670a1dd. The tool is an extension of FastDownward which is under GPL3.

For easy use prebuild binaries are included. The script `stackelberg-planner-sls/build_all` can be used to recompile the tool.

## Scripts
There is a number of scripts included to rerun the experiments. Those are starting with `1_` up to `6_` and must be executed in that order.

Some additional scripts are included for running single experiments or for validating the toolchain with simple networks.

| Script | Description |
|--------|-------------|
| `1_generate_all_pddls.sh` | Generates `*.pddl` and `*.log` files in `data/*_pddl/` files out of network description `data/*_json/*.json` files.
| `2_solve_all.sh` | Solves the Stackelberg models of the network update problems. This can run in parallel with setting `EXECUTOR` (see above).
| `2b_solve_snowcap.sh` | Solves the Snowcap models of the network update problems. This can run in parallel with setting `EXECUTOR` (see above).
| `3_check_consistency.sh` | compares the results (solvable/no solution) against the results of the TAPAAL tool
| `4_extract_all.sh` | generates the CSV report files
| `5_check_batch_counts.sh` | compares the result batch counts of the concurrent mode against the concurrent TAPAAL results
| `6_plot_all.sh` | generates the plots
| `solve_one_*.sh` | runs one problem using the Stackelberg solver
| `solve_simple.sh` | just solves the simple networks (for validation)
| `test_simple.sh` | checks the results of the simple networks for correctness

# Running experiments
Following command sequence was used to run the experiments:
```sh
unset TIME
export MEMORY=7340032
export EXECUTOR=sbatch
./1_generate_all_pddls.sh
./2_solve_all.sh
./2b_solve_snowcap.sh
./3_check_consistency.sh
./4_extract_all.sh
./5_check_batch_counts.sh
./6_plot_all.sh
```

## Faster execution
All intermediate results are in the archive, so steps can be skipped. Alternatively the execution time can be limited (causing that more instances will not be solved). Setting it to 5 minutes is a good value for quick results:
```sh
# replace "unset TIME" with
export TIME=300
```
