#!/bin/bash

mkdir -p consistence_checks

grep "attacker cost: 2147483647" -r data/nested_results/  | grep -oP ".*(?<=\:)" | grep -oP ".*(?=stackelberg_seq)" | sort | uniq > consistence_checks/stackelberg_seq.sat
grep "END Pareto-frontier" -lr data/nested_results/ | xargs grep -L "attacker cost: 2147483647" | grep -oP ".*(?=stackelberg_seq)" | sort | uniq > consistence_checks/stackelberg_seq.not

grep "attacker cost: 2147483647" -r data/nested_results/  | grep -oP ".*(?<=\:)" | grep -oP ".*(?=stackelberg_cc)" | sort | uniq > consistence_checks/stackelberg_cc.sat
grep "END Pareto-frontier" -lr data/nested_results/ | xargs grep -L "attacker cost: 2147483647" | grep -oP ".*(?=stackelberg_cc)" | sort | uniq > consistence_checks/stackelberg_cc.not

grep "Query is sat" -r data/nested_results/  | grep -oP ".*(?<=\:)" | grep -oP ".*(?=verifypn)" | sort | uniq > consistence_checks/pn.sat
grep "Query is NOT" -r data/nested_results/  | grep -oP ".*(?<=\:)" | grep -oP ".*(?=verifypn)"  | sort | uniq > consistence_checks/pn.not

echo "## Inconsistency in satisfiable problems [sequential] (if no lines are printed below, the results are consistent) ##"
comm -12 consistence_checks/pn.sat consistence_checks/stackelberg_seq.not
echo "## Inconsistency in unsatisfiable problems [sequential] (if no lines are printed below, the results are consistent) ##"
comm -12 consistence_checks/pn.not consistence_checks/stackelberg_seq.sat

echo "## Inconsistency in satisfiable problems [concurrent] (if no lines are printed below, the results are consistent) ##"
comm -12 consistence_checks/pn.sat consistence_checks/stackelberg_cc.not
echo "## Inconsistency in unsatisfiable problems [concurrent] (if no lines are printed below, the results are consistent) ##"
comm -12 consistence_checks/pn.not consistence_checks/stackelberg_cc.sat
