# Artefact name: Artefact for Kaki
The files in this package aim to assist you in running our tool and generating the results.

All the experiments used in the paper were conducted on a compute-cluster running Ubuntu version 18.04.5 on an AMD Opteron(tm) Processor 6376 with a 1GB memory limit and 5 minute timeout.

We have provided our precomputed results of the full benchmark in the output folder.
 

## Requirements
To run Kaki on the iFM 2022 Virtual Machine, the java runtime version must be changed. This can be done by running

`sudo update-alternatives --config java`

and selecting the java runtime version 16.


## Test Phase
In order to check if the scripts for generating Figure 8, Figure 9, Figure 10 and Table 1 is functional, run the following commands:
`sudo apt-get install texlive-latex-extra`
`python3 generate_figure_opt_comp.py`
`python3 generate_table.py`


To check if Kaki runs correctly on a single problem, run the following command:
`java -jar Kaki.jar verifypn-linux64 problems/zoo_json_waypoint1/Aarnet_1.json`


To check if FLIP runs correctly on a single problem, run:
`bash setupflip.sh`
followed by 
`java -jar Kaki.jar _ problems/zoo_json_waypoint1/Aarnet_1.json -f subpaths`
`cd flip`
`python2 ../runflipwithdfa.py ../problems/zoo_json_waypoint1/Aarnet_1.json ../subpaths`


To check if the generation of new problems works correctly, run the command:
`java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _test_phase_wp2 --waypoints 2`


## Generating Figure 8, Figure 9 and Figure 10 from precomputed data
To generate Figure 8 and Figure 9 in our paper using the precomputed data, first install the package:
`sudo apt-get install texlive-latex-extra`
then run the script `generate_figure_opt_comp.py` as follows:

`python3 generate_figure_opt_comp.py`

This outputs the figures in the artefact root folder.

This script expects the data to be located in the folders: output/all (all optimisation techniques enabled), output/eqc (collective update classes enabled), output/td (topological decomposition enabled), output/none (baseline/no optimisation techniques enabled), output/flip and output/netstack.

Estimated time to run: A few seconds


## Generating Table 1 from precomputed data
To generate the latex code for Table 1 in our paper using the precomputed data, first install the package:
`sudo apt-get install texlive-latex-extra`
then run the script `generate_table.py` by:

`python3 generate_table.py`

This script expects the data to be located in the folders: output/all (all optimisation techniques enabled), output/eqc (collective update classes enabled), output/td (topological decomposition enabled), output/none (baseline/no optimisation techniques enabled) and output/flip.

Estimated time to run: A few seconds


## Running Kaki on a single problem
The files in this package aim to assist you in running our tool and generating the results.

To run Kaki, simply execute
```
java -jar Kaki.jar <arguments ...>
```

when given no arguments, it will list the required and optional arguments.

To run Kaki, you will need the Petri net verification engine of TAPAAL called [verifypn](https://github.com/TAPAAL/verifypn/). A binary for linux64 is included in this folder. You should then specify the path to this engine when running Kaki, e.g. with verifypn-linux64 in this same directory, you could run:

```
java -jar Kaki.jar verifypn-linux64 problems/zoo_json_waypoint1/Aarnet_1.json
```

which runs Kaki on problem Aarnet_4.json. For running multiple problems at once, see next section.

By default this has all optimisation techniques enabled. The option -T disables topological decomposition and -E, -C disables the two collective update classes. As an example, the following line runs Kaki with all optimisation techniques disabled:

```
java -jar Kaki.jar -T -C -E verifypn-linux64 problems/zoo_json_waypoint1/Aarnet_1.json
```


## Running Kaki to reproduce data used in Figure 8, Figure 9, Figure 10 and Table 1
To run all the problems, execute the script `run_benchmarks.py` and give it the desired arguments. In our paper we have used the following configurations:

```
./run_benchmarks.py problems -k Kaki.jar -o new_output kaki -n "all"
./run_benchmarks.py problems -k Kaki.jar -ta "-T " -o new_output kaki -n "eqc"
./run_benchmarks.py problems -k Kaki.jar -ta "-E -C" -o new_output kaki -n "td"
./run_benchmarks.py problems -k Kaki.jar -ta "-E -C -T" -o new_output kaki -n "none"
```

for 'all optimization techniques', 'topological decomposition', 'collective update classes', 'baseline/no optimization techniques'. The estimated time on a single machine for each of the above lines are 7, 37, 44 and 100 hours respectively given the default timeout of 60 seconds. The timeout can be specified using the -to argument. 

For the experiments in the paper, all problems were run with a 1GB memory limit and 5 minute timeout.

To run only a subset of the problems, the following command can be executed:
`./run_benchmarks.py problems/zoo_json_waypoint1 -k Kaki.jar -o new_output kaki -n "all"`
This only runs the problems in the folder `problems/zoo_json_waypoint1`, which are the problems containing a single waypoint. This is also the subset of problems used for Figure 9. For the slowest configuration (no optimisation for Kaki), this takes around 8 hours with the default of 60 seconds timeout. Kaki with all optimisation techniques and FLIP are much faster. This can further be reduced by limiting the timeout using the -to argument.

Note, that the script for generating Figure 8 does not include the problems in the `zoo_json_MF` folder as these are looked at seperately, but this can easily be modified in the file `generate_figure_opt_comp.py` by removing the filter.

How to run FLIP is explained in the next point.


## Running FLIP to reproduce data used in Figure 9 and Table 1
To reproduce the flip results in our paper, you will need need to install FLIP (https://gitlab.com/s.vissicchio/flip-vm). This is done by running `bash setupflip.sh` in the artefact folder. NOTE: FLIP relies on gurobipy to use Gurobi and the `setupfile.sh` ensures a limited default license to Gurobi. For the larger experiments, this limited default license does not suffice and an unlimited license is required. A free unlimited academic license can be obtained from the Gurobi Web site (https://www.gurobi.com/downloads/end-user-license-agreement-academic/).

To run FLIP we first need to generate the policy subpaths, this can be done with our tool and it is handled when running `run_benchmarks.py` with flip as the method argument:

```
./run_benchmarks.py problems -k Kaki.jar -o new_output flip
```

Estimated time on a single machine is 6.5 hours given the default timeout of 60 seconds. The timeout can be specified using the -to argument.

A subset of the problems can also be specified:
`./run_benchmarks.py problems/zoo_json_waypoint1 -k Kaki.jar -o new_output flip`
This only runs the problems in the folder `problems/zoo_json_waypoint1`, which are the problems containing a single waypoint. This is also the subset of problems used in Figure 9.


## Running NetStack to reproduce data used in Figure 9
To reproduce the NetStack results from Figure 9 in the paper, you only need to run the script: 

`./run_benchmarks.py problems/zoo_json_waypoint1 -o new_output netstack`

This will generate the data in a new folder called `new_output/netstack` which can either be moved to the output folder or the path for the data can be changed in the script for generating the Figures. (`generate_figure_opt_comp.py`)

Estimated time is a couple of hours with the default 60 seconds timeout. For the experiments in the paper, all problems were run with a 1GB memory limit and 5 minute timeout. The timeout can be specified by the -to argument.


## Generating Problems
The problems in `problems/zoo_json_waypoint1` are the problems from the artefact https://zenodo.org/record/4501982#.YjrzRJHMJH4 by Didriksen et al. They also provide the script that was used to create the problems.

We create additional copies of these with different policies. These can be created using PolicyGenerator.jar. For example, it can be run with:

```
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_wp3 --waypoints 3
```

which creates copies of the problems containing 3 waypoints. Optional arguments here include --waypoints, --alt_waypoints and --cond_enf which specifies how many "Waypoints", "Alternative Waypoints" and "Conditional Enforcements" should be in the output problems. The default value for each option is 0. These problems always include the reachability policy. For the results in the paper we created the following problems:

```
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_wp2 --waypoints 2
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_wp4 --waypoints 4
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_wp8 --waypoints 8
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_alt_wp1 --alt_waypoints 1
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_alt_wp2 --alt_waypoints 2
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_alt_wp4 --alt_waypoints 4
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_cond_enf1 --cond_enf 1
java -jar PolicyGenerator.jar problems/zoo_json_waypoint1 --o _new_cond_enf2 --cond_enf 2
```

The above lines creates new problem folders in a new root folder called `new_problems`. Precomputed problems can be found in the problems folder. Each of the above lines only takes a few seconds to run. The problems folder contains problems with 1,2,4 and 8 waypoints, problems with 1,2 and 4 alternative waypoints, problems with 1 and 2 conditional enforcements and the two problem folders `problems/zoo_json_reachability` and `problems/zoo_json_MF` which are described in the next section.


## Generating Problems with Split Flows
We created new problems with split flows according to the Equal Cost MultiPath routing algorithm, which can be created by first installing networkx 

`python3 -m pip install networkx==2.5`

then running: 

`python3 Generate_NonDet_Zoo_Json.py`

This uses the network topologies in the `gml` folder, which are the same topologies from the artefact by Didriksen et al. This script outputs two folders (in the artefact root folder), one with problems without split flows (similarly to what Diriksen et al. did) and one version with split flows. These problems all only contain the reachability policy. Precomputed problems can be found in `problems/zoo_json_reachability` (without split flows) and `problems/zoo_json_MF` (with split flows).


