import utils.JsonNonDetBuilder as JB
import time,os
import shutil
import random

### Generates a problem and writes it as json
def generate(indir, network, outdir, scale):
    gml = indir + network + ".gml"
    json_multi = f"{outdir}/{network}_{scale}.json"
    json_single = f"zoo_json_reachability/{network}_{scale}.json"

    JB.jsonbuilder(gml, json_multi, json_single, scale)

def generate_all(indir, outdir, scale):
    start = time.time()
    cnt = 0
    dir = f"{outdir}"
    if os.path.exists(dir):
        shutil.rmtree(dir)
    os.mkdir(dir)

    dir2 = f"zoo_json_reachability"
    if os.path.exists(dir2):
        shutil.rmtree(dir2)
    os.mkdir(dir2)

    for f in os.listdir(indir):
        for i in range(1, scale):
            generate(indir + "/", f[:-4], outdir, i)
            cnt += 1
    print("Operation done in: {} seconds".format((str(time.time()-start))[:5]))
    print(f"Succesfully written {cnt} files.")


#generate("data/gml/", "Aarnet", "data/zoo3", 4)
#generate_all("data/gml", "data/zooND", 5)
generate_all("gml", "zoo_json_MF", 5)
