# Course website

## Teachers 

- Geert van Geest [:custom-orcid:](https://orcid.org/0000-0002-1561-078X)

## Authors

- Geert van Geest [:custom-orcid:](https://orcid.org/0000-0002-1561-078X)
- Patricia Palagi [:custom-orcid:](https://orcid.org/0000-0001-9062-6303)

## Attribution

This course is partly inspired by the [Carpentries Docker course](https://carpentries-incubator.github.io/docker-introduction/)

## License & copyright

**License:** [CC BY-SA 4.0](https://raw.githubusercontent.com/sib-swiss/single-cell-training/master/LICENCE)

**Copyright:** [SIB Swiss Institute of Bioinformatics](https://www.sib.swiss/)

## Material

* This website
* Zoom meeting (through mail)
* Google doc (through mail)
* Slack channel

## Learning outcomes

### General learning outcomes

After this course, you will be able to:

* Understand the basic concepts and terminology associated with virtualization with containers
* Be able to customize, store and share a containerized environment with Docker
* Understand the essential differences between Docker and Singularity
* Be able to use Singularity to run containers on a shared computer environment (e.g. a HPC cluster)

### Learning outcomes explained

To reach the general learning outcomes above, we have set a number of smaller learning outcomes. Each chapter (found at [Course material](course_material/introduction_containers.md)) starts with these smaller learning outcomes. Use these at the start of a chapter to get an idea what you will learn. Use them also at the end of a chapter to evaluate whether you have learned what you were expected to learn.

## Learning experiences

To reach the learning outcomes we will use lectures, exercises, polls and group work. During exercises, you are free to discuss with other participants. During lectures, focus on the lecture only.

### Exercises

Each block has practical work involved. Some more than others. The practicals are subdivided into chapters, and we'll have a (short) discussion after each chapter. All answers to the practicals are incorporated, but they are hidden. Do the exercise first by yourself, before checking out the answer. If your answer is different from the answer in the practicals, try to figure out why they are different.

### Asking questions
During lectures, you are encouraged to raise your hand if you have questions (if in-person), or use the Zoom functionality (if online). Find the buttons in the participants list ('Participants' button):

<figure>
  <img src="assets/images/zoom_icons.png" width="300"/>
</figure>

Alternatively, (depending on your zoom version or OS) use the 'Reactions' button:

<figure>
  <img src="assets/images/reactions_zoom.png" width="200"/>
</figure>

A main source of communication will be our [slack channel](https://www.slack.com). Ask background questions that interest you personally at **#background**. During the exercises, e.g. if you are stuck or don't understand what is going on, use the slack channel **#q-and-a**.  This channel is not only meant for asking questions but also for answering questions of other participants. If you are replying to a question, use the "reply in thread" option:

<figure>
  <img src="assets/images/reply_in_thread.png" width="350"/>
</figure>

The teacher will review the answers, and add/modify if necessary. If you're really stuck and need specific tutor support, write the teachers or helpers personally.

**To summarise:**

* During lectures: raise hand/zoom functionality
* Personal interest questions: **#background**
* During exercises: **\#q-and-a** on slack
