/*******************************************************************************

************
** Function: 
************

  Produces tables and figures (i.e., .tex and .eps files) as well as log (.txt) 
	files that contain output that is manually copied into the text of the article
	or into MATLAB to produce some of the figures in the article. 
	
*******************************************************************************/

clear *
set more off
macro drop _all

********************************************************************************
** Decedents Data
********************************************************************************
 
do Decedents_Analysis_Trajectories
do Decedents_Analysis_Tables
do Decedents_Analysis_Regressions

********************************************************************************
** Core Interviews Data
********************************************************************************
 
do CoreIWs_Analysis_CalibrationTargets
do CoreIWs_Analysis_Tables
do CoreIWs_Analysis_Regressions
do CoreIWs_Analysis_HomeLiquidation

********************************************************************************
** Transfers Data
********************************************************************************
 
do Transfers_Analysis

********************************************************************************
** Model Data
******************************************************************************** 

do Model_Analysis_Transfers_Histogram

********************************************************************************
** SCF vs. HRS comparison
******************************************************************************** 

do SCF_HRS_Trajectories_Age50
do SCF_HRS_Trajectories_Age65

********************************************************************************

clear *
macro drop _all
cap graph drop _all
