/*******************************************************************************

************
** Function: 
************

  Assembles all Stata data sets used in the article.
	
*******************************************************************************/

clear *
set more off
macro drop _all

********************************************************************************
** CPI Deflator
********************************************************************************

do GetCPIdeflator

********************************************************************************
** Helper data
********************************************************************************

do HelperData_Run_All_Files

********************************************************************************
** Decedents Data
********************************************************************************
 
do Decedents_GetSample 
do Decedents_Sample_Supplement
do Decedents_ProcessData

********************************************************************************
** Core Interviews Data
********************************************************************************
 
do CoreIWs_GetSample

********************************************************************************
** Transfers Data
********************************************************************************
 
do Transfers_GetSample 

********************************************************************************
** Model Data
******************************************************************************** 

* Dataset from the baseline model
do Model_Get_Baseline_Sample
do Model_Get_Baseline_Trajectories_Extracts

* Dataset from the no-child counterfactual
do Model_Get_NoChild_Sample
do Model_Get_NoChild_Trajectories_Extracts

********************************************************************************
** Clean up leftover files not required for the analyses
********************************************************************************

erase ${save}/helpers_with_imputations.dta
erase ${save}/randkids.dta
erase ${save}/decedent_sample.dta
erase ${save}/decedent_sample_supplement.dta
erase ${save}/decedent_sample_single.dta
erase ${save}/nochild-merged.dta

********************************************************************************
