/*******************************************************************************

************
** Function: 
************

  Creates data extracts from model data with end-of-life wealth trajectories.
	These are merged in with the decedent sample in Decedents_Analysis_Trajectories.do
	to construct the data-versus-model comparisons in the article.

************
** Inputs  :
************
	
	- nochild-merged.dta    (see Model_Get_NoChild_Sample.do)
	
************
** Outputs :
************
	
	- model_traj_data_childless.dta

*******************************************************************************/

clear *
macro drop _all
set more off 

********************************************************************************
** Directory names
********************************************************************************

do GetDirNames.do

********************************************************************************
** Data
********************************************************************************

use ${save}/nochild-merged.dta, clear

********************************************************************************
** Trajectories
********************************************************************************

keep if (nCln==1)
// drop clones (none to drop in no-child counterfactual)

sort idCln t

* drop those who survive until age 95
by idCln: egen tmp = max(Surv95)
drop if (tmp==1)
drop tmp

gen xnriw=.
replace xnriw=0 if (   dead==1)
replace xnriw=1 if (F1.dead==1)
replace xnriw=2 if (F2.dead==1)
replace xnriw=3 if (F3.dead==1)
replace xnriw=4 if (F4.dead==1)

tab xnriw if t>0

* net worth
gen nwp = .
replace nwp = Nwp65  if (t==0) // initial wealth at age 65
replace nwp = ap + h if (t >0) // later ages
* estate
by idCln: egen tmp = max(Beq) // assign Beq to all observations for each (id nCln)
replace nwp = tmp if (dead==1)  // previously assigned only to t=0
drop tmp

* housing
gen own = .
replace own = (h>0) if ~mi(h) & (dead==0)      // core interviews
* get housing bequest, check if >0
by idCln: egen tmp = max(HBeq)
replace own = (tmp>0) if ~mi(tmp) & (dead==1) // exit interview
drop tmp

keep if inrange(xnriw,0,4)
// keep only interviews relevant for trajectories

keep if (t>0)
// don't count age 65 as an interview

******************************
** All (Childless)
******************************

preserve

format nwp %9.0fc

collapse (p10) p10=nwp ///
         (p25) p25=nwp ///
				 (p50) p50=nwp ///
				 (p75) p75=nwp ///
				 (p90) p90=nwp ///
				 , by(xnriw)

list, clean noobs sep(0)			 
				 
save ${save}/model_traj_data_childless.dta, replace
// save copy				 
				 				 
restore

/*

QUANTILES:
	
STATA:
    xnriw   p10   p25   p50   p75   p90  
        0     0     0     0   149   372  
        1     0     0    10   167   391  
        2     0     0    52   199   443  
        3     0     0    80   222   491  
        4     0     0   100   246   536 

*/

********************************************************************************
