/*******************************************************************************

************
** Function: 
************

  Constructs helper hours for core 1998-2010 and exit 2004-2012. 
	
*******************************************************************************/

clear *
set more off
macro drop _all

********************************************************************************
** Run auxiliary files
********************************************************************************

* ADLs, exit 2004-2012
do HelperData_Get_Exit_ADLs

* helper counts, core 1998-2010, exit 2004-2012
do HelperData_Get_Helper_Counts

* core data 2002-2010
do HelperData_Get_CoreData

* core data 1998-2000
do HelperData_Get_Add_Core_Waves

* exit data 2004-2012
do HelperData_Get_ExitData

* the above combine files and define many additional variables (care arrangements, etc.)
do HelperData_CombineData

* impute missing hours for nursing home care recipients
do HelperData_ImputeHours
 
********************************************************************************

* result:
describe

// -> these are the variables merged to the datasets used in the analysis

//    we add the suffix 'new' to distinguish them from our old method of
//    computing care hours and arrangements (we retain the originals for
//    comparison)

********************************************************************************
** Erase temporary files used to produce helper data extract
********************************************************************************

erase ${save}/exit_adls.dta
erase ${save}/helper_counts.dta
erase ${save}/helpers_core_add_waves.dta
erase ${save}/helpers_core.dta
erase ${save}/helpers_exit.dta
erase ${save}/helpers_combined.dta

********************************************************************************
