/*******************************************************************************

************
** Function: 
************

  Defines global macros with all input/output file and directory paths.
	In the replication package, these are all defined relatively (i.e., using '..'),
  so no edits to this file should be needed.	
	
*******************************************************************************/

******************
* input files & directories
******************

global inputdir "../Inputs"

global hrsexit  "${inputdir}/HRS"
global hrscore  "${inputdir}/HRS"
global tracker  "${inputdir}/HRS/TRK2016TR_R.dta"

global randhrs  "${inputdir}/HRS_RAND/randhrs1992_2014v2.dta"
global randfamr "${inputdir}/HRS_RAND/randhrsfamr1992_2014v1.dta"
global randfamk "${inputdir}/HRS_RAND/randhrsfamk1992_2014v1.dta"

global randfat98 "${inputdir}/HRS_RAND/hd98f2c" // these are the actual
global randfat00 "${inputdir}/HRS_RAND/h00f1c"  // names of the fat files.
global randfat02 "${inputdir}/HRS_RAND/h02f2c"  // the names identify the
global randfat04 "${inputdir}/HRS_RAND/h04f1b"  // the most recent release
global randfat06 "${inputdir}/HRS_RAND/h06f3a"  // of the data and so
global randfat08 "${inputdir}/HRS_RAND/h08f3a"  // help us keep track.
global randfat10 "${inputdir}/HRS_RAND/hd10f5e"

global langaweir "${inputdir}/HRS_LangaWeir/cogfinalimp_9516wide.dta"

global oopmedexp "${inputdir}/OutOfPocketMedExp/oopme_final_extract.dta"

global scf_panel "${inputdir}/SCF/rscfp2009panel.dta"

global cpi       "${inputdir}/CPI/CPI_90_2014.xlsx"

global ModelOutput "${inputdir}/Inputs_from_Model" // inputs produced in MATLAB

********************
* output directories
********************

global outputdir "../Output"

global save "${outputdir}/data"  // -> .dta   output
global figs "${outputdir}/figs"  // -> .eps   output
global tabs "${outputdir}/tabs"  // -> .tex   output
global logs "${outputdir}/logs"  // -> .log   output

*******************************
* confirm directories and files
*******************************

if ("$S_OS" == "MacOSX") local nul = .
if ("$S_OS" == "Windows") local nul = "nul"

confirm file ${hrscore}/`nul'
confirm file ${hrsexit}/`nul'
confirm file ${tracker}

confirm file ${randhrs}
confirm file ${randfamr}
confirm file ${randfamk}

foreach fat in fat98 fat00 fat02 fat04 fat06 fat08 fat10 {
  confirm file ${rand`fat'}.dta
}

confirm file ${langaweir}
confirm file ${oopmedexp}
confirm file ${scf_panel}
confirm file ${cpi}

confirm file ${ModelOutput}/`nul'

confirm file ${save}/`nul'
confirm file ${figs}/`nul'
confirm file ${tabs}/`nul'
confirm file ${logs}/`nul'
