// First, import Excel sheet CPI_90_2014.xlsx.
// Source: https://fred.stlouisfed.org/series/CPIAUCNS
// Consumer Price Index for All Urban Consumers: All Items in U.S. City Average
// Monthly, 1982-1984=100, Not seasonally adjusted

clear *
macro drop _all
set more off

do GetDirNames.do

import excel using ${cpi}, firstrow clear

gen deflator98 = Dec / 163.9
gen deflator00 = Dec / 174
gen deflator02 = Dec / 180.9
gen deflator04 = Dec / 190.3
gen deflator06 = Dec / 201.8
gen deflator08 = Dec / 210.228
gen deflator10 = Dec / 219.179 	    // divide december values by baseline year (2010)
									                  // to get our deflator
gen deflator12 = Dec / 229.601
gen deflator14 = Dec / 234.812									

drop Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec		
keep if year==1998 | year==2000 | year==2002 | year==2004 | ///
        year==2006 | year==2008  | year==2010 | year==2012 | year==2014
									// just keep observations we need
gen w = (year-1990)/2			// create wave number
order w
drop year
									
save ${save}/CPIdeflator.dta, replace				// save in Stata format
