/*******************************************************************************
	
************
** Function: 
************

  Performs regression analyses on the decedent sample.

************
** Inputs  : 
************

  - decedent_sample_single_final.dta    (see Decedents_ProcessData.do)

************
** Outputs : 
************

	- TAB9.tex
	
  - TABK4.tex
	- TABK5.tex
	- TABK6.tex	
  - TABK7.tex
	- TABK8.tex
	- TABK9.tex
	- TABK10.tex
	
*******************************************************************************/

clear *
set more off
macro drop _all

********************************************************************************
** Director names
********************************************************************************

do GetDirNames.do

********************************************************************************
** DATA
********************************************************************************	

use ${save}/decedent_sample_single_final, clear

********************************************************************************
** Additional variables
********************************************************************************

gen L1caretypenew = L.caretypenew
by hhidpn: carryforward L1caretypenew, gen(cL1caretypenew)

gen L1ygonly50new = L.ygonly50new
by hhidpn: carryforward L1ygonly50new, gen(cL1ygonly50new)

gen exitiw = (xIW==1)

********************************************************************************
** Coefficient labels
********************************************************************************

global COEFLAB ///
  coeflab( ///
		hchild "Num. children" ///
		tohrswklyinnmnew6log "Avg. Total Weekly LTC Hours" ///
		yghrswklynew6log "Avg. Weekly Hours from Children" ///
		age "Age" ///
		sex "Female" ///
		1.raracem "Race: white" ///
		2.raracem "Race: Black" ///
		3.raracem "Race: other" ///
		rahispan "Hispanic" ///
		1.educ "Educ: less than high school" ///
		2.educ "Educ: high school / GED" ///
		4.educ "Educ: some college" ///
		5.educ "Educ: college graduate" ///
		everCpl "Ever coupled" ///
		rnhmliv6ymean "Share of Interviews in NH" ///
    logpi "log(Avg. household inc.)" ///
		1.rarelig "Religion: Protestant" ///
		2.rarelig "Religion: Catholic" ///
		3.rarelig "Religion: Jewish" ///
		4.rarelig "Religion: none" ///
		5.rarelig "Religion: other" ///
		1.crcendiv "Census: New England" ///
		2.crcendiv "Census: Mid Atlantic" ///
		3.crcendiv "Census: EN Central" ///
		4.crcendiv "Census: WN Central" ///
		5.crcendiv "Census: S Atlantic" ///
		6.crcendiv "Census: ES Central" ///
		7.crcendiv "Census: WS Central" ///
		8.crcendiv "Census: Mountain" ///
		9.crcendiv "Census: Pacific" ///
		11.crcendiv "Census: Not U.S." ///		
		7.w "Interview wave=7" ///
		8.w "Interview wave=8" ///
		9.w "Interview wave=9" ///
		10.w "Interview wave=10" ///
		11.w "Interview wave=11" ///
		_cons "Constant" ///
		     ) 	

********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************

********************************************************************************
** APPENDIX TABLE K.7
** APPENDIX TABLE K.8
********************************************************************************

global X ///
    tohrswklyinnmnew6log yghrswklynew6log
		
global CONTROLS ///
    age sex i.raracem rahispan i.educ ///
    hchild ///		
		everCpl logpi ///
		i.rarelig i.crcendiv ///
	  i.w 
		
global IF ///
  if (haschild==1)		
		
global WEIGHT ///
   [aw=crwtall]		

global VCE ///
  vce(robust)
	 
est clear		
		
* overall estate
* extensive margin
qui: eststo: regress anyBeq ${X} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  

* overall estate
* intensive margin
qui: eststo: regress logEstVal10 ${X} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean 	
		
* is home part of the estate?
* linear probability model
qui: eststo: regress homeBeq ${X} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean    

* is home part of the estate? broad measure
* linear probability model
qui: eststo: regress homeBeqOrIvtr ${X} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  

local OPTS ///
  b(a2) se varwidth(24) starlevel(* .1 ** .05 *** .01) nonum ${COEFLAB} ///
	stats(N r2 ymean, label("Observations" "$ R^{2} $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  nofloat nonote ///
  substitute( \begin{tabular}{l*{4}{c}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccc} ///
              \end{tabular} ///
			  \end{tabular*}) ///
  mlabel("Any Estate" "Log(Value)" "Bequest" "Bequest+", ///
    lhs(" & \multicolumn{2}{c}{Overall Estate} & \multicolumn{2}{c}{Housing} \\ \cline{2-3} \cline{4-5}") ///
        )				

* Output main result:
local FILENAME ${tabs}/TABK7.tex	
esttab *, `OPTS' keep(${X})
esttab * using `FILENAME', booktabs replace `OPTS' keep(${X})
cat `FILENAME'

* Output full table:
local OPTS ///
  wide ///
  b(a2) se varwidth(24) starlevel(* .1 ** .05 *** .01) nonum ${COEFLAB} ///
	stats(N r2 ymean, label("Observations" "$ R^{2} $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  nofloat nonote ///
  substitute( \begin{tabular}{l*{4}{cc}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccccc} ///
              \end{tabular} ///
			  \end{tabular*}) ///
	mlabel(none) ///
  collab("Coef" "SE", ///
    lhs(" & \multicolumn{4}{c}{Overall Estate} & \multicolumn{4}{c}{Housing} \\ \cline{2-5} \cline{6-9} & \multicolumn{2}{c}{Any Estate} & \multicolumn{2}{c}{Log(Value)} & \multicolumn{2}{c}{Bequest} & \multicolumn{2}{c}{Bequest+} \\ % \cline{2-3} \cline{4-5} \cline{6-7} \cline{8-9} % ") ///
        )	

local DROP ///
  //drop(1.raracem 1.educ 1.crcendiv 1.rarelig 7.w)

local FILENAME ${tabs}/TABK8.tex		
esttab *, `OPTS'
esttab * using `FILENAME', booktabs replace `OPTS' `DROP' nogaps
cat `FILENAME'

/*
----------------------------------------------------------------------------------------
& \multicolumn{2}{c}{O~t   Any Estate      Log(Value)         Bequest        Bequest+   
----------------------------------------------------------------------------------------
Avg. Total Weekly LTC ~s       -0.051***        -0.15***       -0.074***       -0.067***
                             (0.0077)         (0.039)        (0.0081)        (0.0086)   

Avg. Weekly Hours from~n        0.023***         0.14***        0.046***        0.061***
                             (0.0081)         (0.043)        (0.0081)        (0.0087)   
----------------------------------------------------------------------------------------
Observations                    2,818           1,641           2,820           2,820   
$ R^{2} $                        0.22            0.26            0.13            0.10   
Mean of dep. var.                0.65           11.53            0.37            0.50   
----------------------------------------------------------------------------------------
*/
********************************************************************************
** APPENDIX TABLE K.9
********************************************************************************

global X ///
    tohrswklyinnmnew6log yghrswklynew6log	

global ADDX ///
    rnhmliv6ymean	
		
global CONTROLS ///
    age sex i.raracem rahispan i.educ ///
    hchild ///		
		everCpl logpi ///
		i.rarelig i.crcendiv ///
	  i.w 
		
global IF ///
  if (haschild==1)		
		
global WEIGHT ///
   [aw=crwtall]		

global VCE ///
  vce(robust)
	 
est clear	
	
* Columns 1 & 2: Overall estate, extensive margin 
* Baseline
qui: eststo: regress anyBeq ${X}         ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  
* With NH Control
qui: eststo: regress anyBeq ${X} ${ADDX} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  

* Columns 3 & 4: Overall estate, intensive margin 
* Baseline
qui: eststo: regress logEstVal10 ${X}         ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean 	
* With NH Control
qui: eststo: regress logEstVal10 ${X} ${ADDX} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean 

* Columns 5 & 6: Housing bequest
* Baseline
qui: eststo: regress homeBeq ${X}         ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean    
* With NH Control
qui: eststo: regress homeBeq ${X} ${ADDX} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  

* Columns 5 & 6: Housing bequest or inter-vivos transfer
qui: eststo: regress homeBeqOrIvtr ${X}         ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean  
* With NH Control
qui: eststo: regress homeBeqOrIvtr ${X} ${ADDX} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
qui: estadd ysumm, mean 

local OPTS ///
  b(a2) se varwidth(24) starlevel(* .1 ** .05 *** .01) nonum ${COEFLAB} ///
  keep(${X} ${ADDX}) ///
  ///scalar("ymean Mean of dep. var.") ///
	nofloat nonote nonum ///
	stats(N r2 ymean, labels("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  substitute( \begin{tabular}{l*{8}{c}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccccc} ///
              \end{tabular} ///
			  \end{tabular*}) ///
  mlabel("(1)" "(2)" "(3)" "(4)" "(5)" "(6)" "(7)" "(8)", ///
    lhs(" & \multicolumn{4}{c}{Overall Estate} & \multicolumn{4}{c}{Housing} \\ \cline{2-5} \cline{6-9} & \multicolumn{2}{c}{Any Estate} & \multicolumn{2}{c}{Log(Value)} & \multicolumn{2}{c}{Bequest} & \multicolumn{2}{c}{Bequest+} \\ \cline{2-3} \cline{4-5} \cline{6-7} \cline{8-9}") ///
        )

local FILENAME ${tabs}/TABK9.tex		
esttab *, `OPTS'
esttab * using `FILENAME', booktabs replace `OPTS'
cat `FILENAME'

/*
--------------------------------------------------------------------------------------------------------------------------------------------------------
& \multicolumn{4}{c}{O~t          (1)             (2)             (3)             (4)             (5)             (6)             (7)             (8)   
--------------------------------------------------------------------------------------------------------------------------------------------------------
Avg. Total Weekly LTC ~s       -0.051***       -0.016*          -0.15***       -0.066          -0.074***       -0.018*         -0.067***       -0.026** 
                             (0.0077)        (0.0094)         (0.039)         (0.048)        (0.0081)         (0.010)        (0.0086)         (0.011)   

Avg. Weekly Hours from~n        0.023***      -0.0038            0.14***        0.078           0.046***       0.0027           0.061***        0.030***
                             (0.0081)        (0.0091)         (0.043)         (0.048)        (0.0081)        (0.0093)        (0.0087)        (0.0099)   

Share of Interviews in~H                        -0.24***                        -0.68***                        -0.39***                        -0.28***
                                              (0.036)                          (0.22)                         (0.035)                         (0.041)   
--------------------------------------------------------------------------------------------------------------------------------------------------------
Observations                    2,818           2,818           1,641           1,641           2,820           2,820           2,820           2,820   
$ R^2 $                          0.22            0.23            0.26            0.26            0.13            0.16            0.10            0.12   
Mean of dep. var.                0.65            0.65           11.53           11.53            0.37            0.37            0.50            0.50   
--------------------------------------------------------------------------------------------------------------------------------------------------------
*/
********************************************************************************
** APPENDIX TABLE K.10
********************************************************************************

global X ///
    tohrswklyinnmnew6log yghrswklynew6log				
		
global CONTROLS ///
    age sex i.raracem rahispan i.educ ///
    hchild ///		
		everCpl logpi ///
		i.rarelig i.crcendiv ///
	  i.w 
		
global IF ///
  & (haschild==1)		
		
global WEIGHT ///
   [aw=crwtall]		

global VCE ///
  vce(robust)
	 
est clear			
		
* Columns 1-2: Renters	
		
* Column 1: Overall estate, extensive margin 
qui: eststo: regress anyBeq ${X} ${CONTROLS} ${WEIGHT} if (everOwn==0) ${IF}, ${VCE}
qui: estadd ysumm, mean  
* Columns 2: Overall estate, intensive margin 
qui: eststo: regress logEstVal10 ${X} ${CONTROLS} ${WEIGHT} if (everOwn==0) ${IF}, ${VCE}
qui: estadd ysumm, mean 	

* Column 3-6: Owners

* Column 3: Overall estate, extensive margin 
qui: eststo: regress anyBeq ${X} ${CONTROLS} ${WEIGHT} if (everOwn==1) ${IF}, ${VCE}
qui: estadd ysumm, mean  
* Columns 4: Overall estate, intensive margin 
qui: eststo: regress logEstVal10 ${X} ${CONTROLS} ${WEIGHT} if (everOwn==1) ${IF}, ${VCE}
qui: estadd ysumm, mean 

* Column 5: Housing bequest
qui: eststo: regress homeBeq ${X} ${CONTROLS} ${WEIGHT} if (everOwn==1) ${IF}, ${VCE}
qui: estadd ysumm, mean    
* Column 6: Housing bequest or inter-vivos transfer
qui: eststo: regress homeBeqOrIvtr ${X} ${CONTROLS} ${WEIGHT} if (everOwn==1) ${IF}, ${VCE}
qui: estadd ysumm, mean  

local OPTS ///
  b(a2) se r2 varwidth(24) starlevel(* .1 ** .05 *** .01) nonum ${COEFLAB} ///
	keep(${X}) ///
  ///scalar("ymean Mean of dep. var.") ///
	nofloat nonote ///
	stats(N r2 ymean, labels("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  substitute( \begin{tabular}{l*{6}{c}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
              \end{tabular} ///
			  \end{tabular*}) ///
  mlabel("Any Estate" "Log(Value)" "Any Estate" "Log(Value)" "Home Beq." "Home Beq.+", ///
    lhs(" & \multicolumn{2}{c}{Renters} & \multicolumn{4}{c}{Owners} \\ \cline{2-3} \cline{4-7}") ///
        )

local FILENAME ${tabs}/TABK10.tex			
esttab *, `OPTS'
esttab * using `FILENAME', booktabs replace `OPTS'
cat `FILENAME'


/*
------------------------------------------------------------------------------------------------------------------------
& \multicolumn{2}{c}{R~    Any Estate      Log(Value)      Any Estate      Log(Value)       Home Beq.      Home Beq.+   
------------------------------------------------------------------------------------------------------------------------
Avg. Total Weekly LTC ~s       -0.054***        -0.29**        -0.040***        -0.12***       -0.092***       -0.077***
                              (0.014)          (0.12)        (0.0088)         (0.039)         (0.010)         (0.010)   

Avg. Weekly Hours from~n        0.021            0.18          0.0077            0.11**         0.047***        0.055***
                              (0.013)          (0.13)        (0.0096)         (0.043)         (0.011)         (0.011)   
------------------------------------------------------------------------------------------------------------------------
Observations                      826             242           1,985           1,397           1,985           1,985   
$ R^2 $                          0.20            0.32            0.15            0.26            0.12            0.08   
Mean of dep. var.                0.36            9.97            0.76           11.78            0.52            0.67   
------------------------------------------------------------------------------------------------------------------------
*/
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************

********************************************************************************
** APPENDIX TABLE K.4
********************************************************************************

global Y ///
  wlthhistAnnDiffcpw
	
global PREV_WEALTH ///
  cL1atotb10_1000s	
	
global PREV_WEALTH_QTILE ///
  cL1atotb10_quintiles
	
global X ///
  cL1own	
	
global CONTROLS ///
  age sex i.raracem rahispan i.educ hchild ///
	i.adla i.iadlza rmemrye ///
	rnhmliv ///
	i.rarelig i.crcendiv i.w exitiw

global IF	///
  & (hcpl==0 & hchild>0 & hchild<.)
	
global PWEIGHT ///
  [pw=crwtall]

global AWEIGHT ///
	[aw=crwtall]
	
est clear

* top quintile
qui: eststo: qreg ${Y} ${X} ${CONTROLS} ${PWEIGHT} if (${PREV_WEALTH_QTILE}==5 ${IF}), wlsiter(50)
qui: summ ${PREV_WEALTH} ${AWEIGHT} if e(sample)==1, det
estadd scalar W = round(`=r(p50)')
qui: summ ${Y} ${AWEIGHT} if e(sample)==1, det
estadd scalar D = round(`=r(p50)')
qui summ ${X} ${AWEIGHT} if e(sample)==1
estadd scalar H = round(`=r(mean)',.01)

* fourth
qui: eststo: qreg ${Y} ${X} ${CONTROLS} ${PWEIGHT} if (${PREV_WEALTH_QTILE}==4 ${IF}), wlsiter(50)
qui: summ ${PREV_WEALTH} ${AWEIGHT} if e(sample)==1, det
estadd scalar W = round(`=r(p50)')
qui: summ ${Y} ${AWEIGHT} if e(sample)==1, det
estadd scalar D = round(`=r(p50)')
qui summ ${X} ${AWEIGHT} if e(sample)==1
estadd scalar H = round(`=r(mean)',.01)

* third
qui: eststo: qreg ${Y} ${X} ${CONTROLS} ${PWEIGHT} if (${PREV_WEALTH_QTILE}==3 ${IF}), wlsiter(50)
qui: summ ${PREV_WEALTH} ${AWEIGHT} if e(sample)==1, det
estadd scalar W = round(`=r(p50)')
qui: summ ${Y} ${AWEIGHT} if e(sample)==1, det
estadd scalar D = round(`=r(p50)')
qui summ ${X} ${AWEIGHT} if e(sample)==1
estadd scalar H = round(`=r(mean)',.01)

* second
qui: eststo: qreg ${Y} ${X} ${CONTROLS} ${PWEIGHT} if (${PREV_WEALTH_QTILE}==2 ${IF}), wlsiter(50)
qui: summ ${PREV_WEALTH} ${AWEIGHT} if e(sample)==1, det
estadd scalar W = round(`=r(p50)')
qui: summ ${Y} ${AWEIGHT} if e(sample)==1, det
estadd scalar D = round(`=r(p50)')
qui summ ${X} ${AWEIGHT} if e(sample)==1
estadd scalar H = round(`=r(mean)',.01)

local COEFLAB ///
  coeflab(cL1own "Own home (prev. interview)" ///
					age "Age" ///
					sex "Female" ///
					1.raracem "Race: white" ///
					2.raracem "Race: Black" ///
					3.raracem "Race: other" rahispan "Hispanic" ///
					1.educ "Educ: less than high school" ///
					2.educ "Educ: high school or GED" ///
					4.educ "Educ: some college" ///
					5.educ "Educ: college graduate" ///
					hchild "Number of children" ///
					0.adla "No ADL limitations" ///
					1.adla "1 ADL limitation" ///
					2.adla "2 ADL limitations" ///
					3.adla "3 ADL limitations" ///
					4.adla "4 ADL limitations" ///
					5.adla "5 ADL limitations" ///
					0.iadlza "No IADL limitations" ///
					1.iadlza "1 IADL limitation" ///
					2.iadlza "2 IADL limitations" ///
					3.iadlza "3 IADL limitations" ///
					4.iadlza "4 IADL limitations" ///
					5.iadlza "5 IADL limitations" ///
					rmemrye "Ever had memory disease"  ///
					rnhmliv "Nursing home resident" ///
		      1.rarelig "Religion: Protestant" ///
					2.rarelig "Religion: Catholic" ///
					3.rarelig "Religion: Jewish" ///
		      4.rarelig "Religion: none" ///
					5.rarelig "Religion: other" ///
		      1.crcendiv "Census: New England" ///
					2.crcendiv "Census: Mid Atlantic" ///
		      3.crcendiv "Census: EN Central" ///
					4.crcendiv "Census: WN Central" ///
		      5.crcendiv "Census: S Atlantic" ///
					6.crcendiv "Census: ES Central" ///
		      7.crcendiv "Census: WS Central" ///
					8.crcendiv "Census: Mountain" ///
		      9.crcendiv "Census: Pacific" ///
					11.crcendiv "Census: Not U.S." ///	
					exitiw "Exit interview" ///
		      5.w "Interview wave=5" ///
					6.w "Interview wave=6" ///
		      7.w "Interview wave=7" ///
					8.w "Interview wave=8" ///
		      9.w "Interview wave=9" ///
					10.w "Interview wave=10" ///
					11.w "Interview wave=11" ///
					_cons "Constant" ///
		     ) /// 
				 
local OPTS ///
  b(%9.1fc) se wide mlab("Top" "4th" "3rd" "2nd" ///
        , lhs( " Median regressions by & \multicolumn{8}{c}{Dependent variable: Annualized change in wealth (BACKSLASH$ 1000s).} \\ \cline{2-9} Lagged wealth quintile: "  ) /// 
        ) ///
  starlevel(* .1 ** .05 *** .01) `COEFLAB' nofloat nonote nonum ///
	stats(N W D H, labels("Observations" "\hline Median lagged wealth" "Median change in wealth" "Home ownership rate") ///
	               fmt(%9.0fc %9.0fc %9.0fc %9.2fc)) ///
  substitute( \begin{tabular}{l*{4}{cc}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccccc} ///
			        \end{tabular} ///
			        \end{tabular*} ///
							BACKSLASH ///
							\ )

local DROP ///
  drop(1.raracem 1.educ 0.adla 0.iadlza *.rarelig *.crcendiv *.w)

local FILENAME ${tabs}/TABK4.tex
esttab *, `OPTS'
esttab * using `FILENAME', replace booktabs `OPTS' `DROP'
cat `FILENAME'

********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************

********************************************************************************
** TABLE 9
** APPENDIX TABLE K.5
********************************************************************************

global Y ygonly50new
// =1 if >50% care from children and no NH care, =0 otherwise

global X cL1own
// previous ownership, carried forward from most recent interview

global CONTROLS ///
  cL1atotb10_ihs age sex i.raracem rahispan i.educ hchild ///
	i.adla i.iadlza rmemrye ///
  i.rarelig i.crcendiv i.w exitiw

global WEIGHT ///
  [aw=crwtall]

global IF ///
  if (caretypenew>0 & caretypenew<.) & (nochild==0) & (hcpl==0)

global VCE ///
  vce(cluster hhid)	
	
est clear

** probability of being in IC, given receiving care this period
eststo: reg ${Y}      ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${WEIGHT} ${IF}, ${VCE}
estadd ysumm, mean

** probability of entering IC, given receiving care this period and no care last period
eststo: reg ${Y}      ${CONTROLS} ${WEIGHT} ${IF} & (cL1caretypenew==0), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${WEIGHT} ${IF} & (cL1caretypenew==0), ${VCE}
estadd ysumm, mean

** probability of remaining in IC, given in IC last period, and receiving care this period
eststo: reg ${Y}      ${CONTROLS} ${WEIGHT} ${IF} & (cL1ygonly50new==1), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${WEIGHT} ${IF} & (cL1ygonly50new==1), ${VCE}
estadd ysumm, mean

** TABLE

local COEFLAB ///
  coeflab(cL1atotb10_ihs "Net worth (prev. interview)" ///
	        cL1own "Own home (prev. interview)" ///
					age "Age" sex "Female" ///
					1.raracem "Race: white" ///
					2.raracem "Race: Black" ///
					3.raracem "Race: other" rahispan "Hispanic" ///
					1.educ "Educ: less than high school" ///
					2.educ "Educ: high school or GED" ///
					4.educ "Educ: some college" ///
					5.educ "Educ: college graduate" ///
					hchild "Number of children" ///
					0.adla "No ADL limitations" ///
					1.adla "1 ADL limitation" ///
					2.adla "2 ADL limitations" ///
					3.adla "3 ADL limitations" ///
					4.adla "4 ADL limitations" ///
					5.adla "5 ADL limitations" ///
					0.iadlza "No IADL limitations" ///
					1.iadlza "1 IADL limitation" ///
					2.iadlza "2 IADL limitations" ///
					3.iadlza "3 IADL limitations" ///
					4.iadlza "4 IADL limitations" ///
					5.iadlza "5 IADL limitations" ///
					rmemrye "Ever had memory disease"  ///
		      1.rarelig "Religion: Protestant" ///
					2.rarelig "Religion: Catholic" ///
					3.rarelig "Religion: Jewish" ///
		      4.rarelig "Religion: none" ///
					5.rarelig "Religion: other" ///
		      1.crcendiv "Census: New England" ///
					2.crcendiv "Census: Mid Atlantic" ///
		      3.crcendiv "Census: EN Central" ///
					4.crcendiv "Census: WN Central" ///
		      5.crcendiv "Census: S Atlantic" ///
					6.crcendiv "Census: ES Central" ///
		      7.crcendiv "Census: WS Central" ///
					8.crcendiv "Census: Mountain" ///
		      9.crcendiv "Census: Pacific" ///
					11.crcendiv "Census: Not U.S." ///	
					exitiw "Exit interview" ///
		      5.w  "Interview wave=5" ///
					6.w  "Interview wave=6" ///
		      7.w  "Interview wave=7" ///
					8.w  "Interview wave=8" ///
		      9.w  "Interview wave=9" ///
					10.w "Interview wave=10" ///
					11.w "Interview wave=11" ///
					_cons "Constant" ///
		     ) 

local OPTS ///
  b(a2) se(a2) starlevel(* .1 ** .05 *** .01) ///
	order(cL1atotb10_ihs cL1own) ///
  `COEFLAB' ///
  nofloat nonote nonum ///
	///scalar("ymean Mean of dep. var.") ///
  stats(N r2 ymean, labels("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  mlab("(1)" "(2)" "(3)" "(4)" "(5)" "(6)", ///
       lhs(" & \multicolumn{6}{c}{Dependent variable: Receiving $>50\%$ care hours from children} \\ \cline{2-7} Conditional on: & & & \multicolumn{2}{c}{No care at prev. interview} & \multicolumn{2}{c}{IC at prev. interview} \\ \cline{4-5} \cline{6-7}") ///  
      ) ///
  substitute( \begin{tabular}{l*{6}{c}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
			  \end{tabular} ///
			  \end{tabular*} )  

** Output main regression results	

local KEEP keep(cL1atotb10_ihs cL1own)				
	
local FILENAME ${tabs}/TAB9.tex
esttab *, `OPTS' `KEEP' compress
esttab * using `FILENAME', booktabs replace `OPTS' `KEEP'
cat `FILENAME'

** Output full regression results
local OPTS ///
  wide ///
  b(a2) se(a1) starlevel(* .1 ** .05 *** .01) ///
	order(cL1atotb10_ihs cL1own) ///
  `COEFLAB' ///
  nofloat nonote nonum ///
	///scalar("ymean Mean of dep. var.") ///
  stats(N r2 ymean, labels("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
  mlab("(1)" "(2)" "(3)" "(4)" "(5)" "(6)", ///
       lhs(" & \multicolumn{12}{c}{Dependent variable: Receiving $>50\%$ care hours from children} \\ \cline{2-13} Conditional on: & & & & & \multicolumn{4}{c}{No care at prev. interview} & \multicolumn{4}{c}{IC at prev. interview} \\ \cline{6-9} \cline{10-13}") ///  
      ) ///
  substitute( \begin{tabular}{l*{6}{cc}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccccccccc} ///
			  \end{tabular} ///
			  \end{tabular*} )  

local DROP ///
	drop(1.raracem 1.educ 1.rarelig 0.adla 0.iadlza 1.crcendiv 5.w)

local FILENAME ${tabs}/TABK5.tex
esttab *, `OPTS' `DROP' compress
esttab * using `FILENAME', booktabs replace `OPTS' `DROP' r2 nogaps
cat `FILENAME'

/*
----------------------------------------------------------------------------------------
& \.. in~}       (1)          (2)          (3)          (4)          (5)          (6)   
----------------------------------------------------------------------------------------
Net.. in~)    0.0066***    0.0010       0.0077***    0.0032     -0.00045      -0.0034   
            (0.0014)     (0.0016)     (0.0022)     (0.0027)     (0.0022)     (0.0026)   

Own.. in~)                   0.12***                  0.094***                  0.064** 
                          (0.018)                   (0.029)                   (0.030)   
----------------------------------------------------------------------------------------
Observat~s     6,148        6,130        2,097        2,088        1,817        1,813   
$ R^2 $         0.16         0.17         0.12         0.13         0.13         0.13   
Mea.. var.      0.40         0.40         0.49         0.49         0.65         0.65   
----------------------------------------------------------------------------------------
*/

********************************************************************************
** APPENDIX TABLE K.6
********************************************************************************

global Y ygonly50new

global X cL1own

global CONTROLS ///
  cL1atotb10_ihs age sex i.raracem rahispan i.educ hchild ///
	i.adla i.iadlza rmemrye ///
  i.rarelig i.crcendiv i.w exitiw

* Adding progressively ``more endogenous'' child characteristics

global KIDX1 ///
  mhndau mhkage mhknkid mheduckmn mhmarkn

global KIDX2 ///
  mhownhmkn mhlv10mikn mhkincb mhworkftkn mhresdkn	
		
global WEIGHT ///
  [aw=crwtall]

global IF ///
  if (caretypenew>0 & caretypenew<.) & (nochild==0) & (hcpl==0)

global VCE ///
  vce(cluster hhid)	
	
* summarize kid variables	
summ ${KIDX1} ${KIDX2} ${IF}	
	
est clear

** probability of being in IC, given receiving care this period
eststo: reg ${Y} ${X} ${CONTROLS}                   ${WEIGHT} ${IF}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1}          ${WEIGHT} ${IF}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1} ${KIDX2} ${WEIGHT} ${IF}, ${VCE}
estadd ysumm, mean

** probability of entering IC, given receiving care this period and no care last period
eststo: reg ${Y} ${X} ${CONTROLS}                   ${WEIGHT} ${IF} & (cL1caretypenew==0), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1}          ${WEIGHT} ${IF} & (cL1caretypenew==0), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1} ${KIDX2} ${WEIGHT} ${IF} & (cL1caretypenew==0), ${VCE}
estadd ysumm, mean

** probability of remaining in IC, given in IC last period, and receiving care this period
eststo: reg ${Y} ${X} ${CONTROLS}                   ${WEIGHT} ${IF} & (cL1ygonly50new==1), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1}          ${WEIGHT} ${IF} & (cL1ygonly50new==1), ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${CONTROLS} ${KIDX1} ${KIDX2} ${WEIGHT} ${IF} & (cL1ygonly50new==1), ${VCE}
estadd ysumm, mean

** TABLE

local COEFLAB ///
  coeflab(cL1atotb10_ihs "Net worth (prev. interview)" ///
	        cL1own "Own home (prev. interview)" ///
          mhndau "Num. daughters" mhkage "Mean child age" ///
					mhknkid "Num. grandchildren" mheduckmn "Mean child educ." ///
					mhmarkn "Num. married" mhownhmkn "Num. own homes" ///
					mhlv10mikn "Num. within 10 miles" mhkincb "Mean child income" ///
					mhworkftkn "Num. work full-time" mhresdkn "Num. co-resident" ///
		     ) /// 

local KEEP ///
  keep(cL1atotb10_ihs cL1own mhndau mhkage mhknkid mheduckmn mhmarkn	///
	    mhownhmkn mhlv10mikn mhkincb mhworkftkn mhresdkn)
 						
local OPTS ///
  b(a2) se r2 starlevel(* .1 ** .05 *** .01) ///
///order(L.ihsatotb10 1.L1own#cL.ihsatotb10) ///
	order(cL1atotb10_ihs cL1own) ///
  `COEFLAB' ///
  nofloat nonote nonum ///
  stats(N r2 ymean, labels("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
	///scalar("ymean Mean of dep. var.") ///
  mlab("(1)" "(2)" "(3)" "(4)" "(5)" "(6)" "(7)" "(8)" "(9)", ///
       lhs(" & \multicolumn{9}{c}{Dependent variable: Receiving $>50\%$ care hours from children} \\ \cline{2-10} Conditional on: & & & & \multicolumn{3}{c}{No care at prev. interview} & \multicolumn{3}{c}{IC at prev. interview} \\ \cline{5-7} \cline{8-10}") ///  
      ) ///
  substitute( \begin{tabular}{l*{9}{c}} ///
              \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lccccccccc} ///
			  \end{tabular} ///
			  \end{tabular*} ) 	 			
				
local FILENAME ${tabs}/TABK6.tex
				
esttab *, `OPTS' `KEEP' compress
esttab * using `FILENAME', replace booktabs `OPTS' `KEEP'
cat `FILENAME'


/*
-------------------------------------------------------------------------------------------------------------------------------
& \.. in~}       (1)          (2)          (3)          (4)          (5)          (6)          (7)          (8)          (9)   
-------------------------------------------------------------------------------------------------------------------------------
Net.. in~)    0.0010       0.0015       0.0015       0.0032       0.0039       0.0033      -0.0034      -0.0030      -0.0034   
            (0.0016)     (0.0017)     (0.0016)     (0.0027)     (0.0027)     (0.0028)     (0.0026)     (0.0026)     (0.0027)   

Own.. in~)      0.12***      0.12***      0.11***     0.094***     0.093***     0.081***     0.064**      0.065**      0.062*  
             (0.018)      (0.019)      (0.019)      (0.029)      (0.029)      (0.030)      (0.030)      (0.030)      (0.032) 

.
.
.

-------------------------------------------------------------------------------------------------------------------------------
N               6130         5847         5090         2088         2007         1751         1813         1757         1533   
R-sq           0.173        0.181        0.247        0.131        0.142        0.194        0.131        0.134        0.160   
Mea.. var.      0.40         0.41         0.41         0.49         0.49         0.50         0.65         0.65         0.64   
-------------------------------------------------------------------------------------------------------------------------------
*/

********************************************************************************
