/*******************************************************************************

************
** Function: 
************

  Produces regression results with full core sample 1998-2010.

************
** Inputs  :
************
	
	- core_sample.dta	(see CoreIWs_GetSample.do)
	
************
** Outputs :
************
	
  - TABA1_SAMPLE_COUNTS_2.txt
		
	- TABK1.tex
	- TABK2.tex
	- TABK3a.tex
	- TABK3b.tex
	- TABK3c.tex

*******************************************************************************/

clear *
macro drop _all
set more off 

********************************************************************************
** Directory names
********************************************************************************

do GetDirNames.do

********************************************************************************
** DATA
********************************************************************************

use ${save}/core_sample, clear

********************************************************************************
***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   **
   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***  
***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   ***   **   
********************************************************************************

********************************************************************************
** Additional variables
********************************************************************************

gen childless = (hchild==0) if !mi(hchild)

gen children = 1 - childless

* care utilization
gen log_rnrsnit = log(rnrsnit)

* wealth/income measures

xtile hatotb10q5 = atotb10 [pw=rwtcrnh], nq(5)
xtile hitot10q5 = hitot10 [pw=rwtcrnh], nq(5)

** for iv

gen daughters = (hndau>0) if !mi(hndau)
replace daughters = 0 if (children==0)

gen child10mi = (hlv10mikn>0) if !mi(hlv10mikn)
replace child10mi = 1 if (hresdkn>0 & hresdkn<.)
replace child10mi = 0 if (children==0)

* ivregress gmm does not handle vce(cluster STRING-VARIABLE)
encode hhid, gen(hhidc)	
	
********************************************************************************
** Setup coefficient labels
********************************************************************************

global COEFLAB ///
  coeflab( ///
	         children "Children" ///
					 rownhm "Homeowner" ///
					 yganyhlprnew "Child LTC helper" ///
					 daughters "Daughters" ///
					 child10mi "Child within 10 miles" ///
					 1.ragender "Male" ///
					 2.ragender "Female" ///
					 1.raracem "Race: white" ///
					 2.raracem "Race: Black" ///
					 3.raracem "Race: other" ///
					 0.rahispan "Non-hispanic" ///
					 1.rahispan "Hispanic" ///
					 0.hcpl "Single" ///
					 1.hcpl "Coupled" ///
					 1.educ "Educ: Less than high school" ///
					 2.educ "Educ: High school or GED" ///
					 4.educ "Educ: Some college" ///
					 5.educ "Educ: College and above" ///
					 0.radla "0 ADLs" ///
					 1.radla "1 ADL" ///
					 2.radla "2 ADLs" ///
					 3.radla "3 ADLs" ///
					 4.radla "4 ADLs" ///
					 5.radla "5 ADLs" ///
					 0.riadlza "0 IADLs" ///
					 1.riadlza "1 IADL" ///
					 2.riadlza "2 IADLs" ///
					 3.riadlza "3 IADLs" ///
					 4.riadlza "4 IADLs" ///
					 5.riadlza "5 IADLs" ///
					 1.cogfunction "Cog. Function: Normal" ///
					 2.cogfunction "Cog. Function: Impaired" ///
					 3.cogfunction "Cog. Function: Demented" ///
					 ragey_b "Age" ///
					 c.ragey_b#c.ragey_b "Age squared" ///
					 1.hatotb10q5 "Net Worth Quintile: 1" ///
					 2.hatotb10q5 "Net Worth Quintile: 2" ///
					 3.hatotb10q5 "Net Worth Quintile: 3" ///
					 4.hatotb10q5 "Net Worth Quintile: 4" ///
					 5.hatotb10q5 "Net Worth Quintile: 5" ///
					 1.hitot10q5 "Income Quintile: 1" ///
					 2.hitot10q5 "Income Quintile: 2" ///
					 3.hitot10q5 "Income Quintile: 3" ///
					 4.hitot10q5 "Income Quintile: 4" ///
					 5.hitot10q5 "Income Quintile: 5" ///
					 1.rcendiv "Census Div: New England" ///
           2.rcendiv "Census Div: Mid Atlantic" ///
           3.rcendiv "Census Div: EN Central" ///
           4.rcendiv "Census Div: WN Central" ///
           5.rcendiv "Census Div: S Atlantic" ///
           6.rcendiv "Census Div: ES Central" ///
           7.rcendiv "Census Div: WS Central" ///
           8.rcendiv "Census Div: Mountain" ///
           9.rcendiv "Census Div: Pacific" ///
           11.rcendiv "Census Div: not U.S." ///
           4.w "Interview wave: 4" ///
					 5.w "Interview wave: 5" ///
					 6.w "Interview wave: 6" ///
					 7.w "Interview wave: 7" ///
					 8.w "Interview wave: 8" ///
					 9.w "Interview wave: 9" ///
					 10.w "Interview wave: 10" ///
					 _cons "Constant" ///
	       )	
		
********************************************************************************
** Sample counts for TABLE A1
********************************************************************************

* turn on log
cap log close
log using ${logs}/TABA1_SAMPLE_COUNTS_2.txt, text replace	

**** all core interviews
* respondents
unique hhidpn if (riwstat==1)
/*
Number of unique values of hhidpn is  32973
Number of records is  136977
*/
* households
unique hhid if (riwstat==1)
/*
Number of unique values of hhid is  21211
Number of records is  136977
*/

**** all core interviews, ages 65+
* respondents
unique hhidpn if (riwstat==1 & (ragey_b>=65 & ragey_b<.))
/*
Number of unique values of hhidpn is  19435
Number of records is  77266
*/
* households
unique hhid if (riwstat==1 & (ragey_b>=65 & ragey_b<.))
/*
Number of unique values of hhid is  13525
Number of records is  77266
*/

**** all core interviews, ages 65+, parents
* respondents
unique hhidpn if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & (hchild>0 & hchild<.))
/*
Number of unique values of hhidpn is  17872
Number of records is  70609
*/
* households
unique hhid if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & (hchild>0 & hchild<.))
/*
Number of unique values of hhid is  12252
Number of records is  70609
*/

**** all core interviews, ages 65+, childless
* respondents
unique hhidpn if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hchild==0)
/*
Number of unique values of hhidpn is  1575
Number of records is  5482
*/
* households
unique hhid if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hchild==0)
/*
Number of unique values of hhid is  1342
Number of records is  5482
*/

**** all core interviews, ages 65+, single
* respondents
unique hhidpn if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hcpl==0)
/*
Number of unique values of hhidpn is  9438
Number of records is  32299
*/
* households
unique hhid if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hcpl==0)
/*
Number of unique values of hhid is  9191
Number of records is  32299
*/

**** all core interviews, ages 65+, single, NH eligible 
**                                         (2+ ADL difficulties and/or cognitive impairment)
* respondents
unique hhidpn if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hcpl==0 ///
                 & ((radla>=2 & radla<.) | inlist(cogfunction,2,3)) )
/*
Number of unique values of hhidpn is  6278
Number of records is  14992
*/
unique hhid if (riwstat==1 & (ragey_b>=65 & ragey_b<.) & hcpl==0 ///
                 & ((radla>=2 & radla<.) | inlist(cogfunction,2,3)) )
/*
Number of unique values of hhid is  6198
Number of records is  14992
*/

* close log
cap log close

********************************************************************************
** APPENDIX TABLE K.1 & APPENDIX TABLE K.2
********************************************************************************	

** Children and nursing home utilization
		
global X ///
  children

global CONTROLS ///
  i.ragender i.raracem i.rahispan i.hcpl i.educ ///
  i.radla i.riadlza i.cogfunction ///
	ragey_b c.ragey_b#c.ragey_b ///
	i.hatotb10q5 i.hitot10q5 rownhm ///
	i.rcendiv ///
	i.w

global IF ///
  if (ragey_b >= 65 & ragey_b < .) & ((radla>=2 & radla<.) | inlist(cogfunction,2,3)) & (hcpl==0)
	
global WEIGHT ///
  [pw=rwtcrnh]	

global VCE ///
  vce(cluster hhid)
	
global U ///
  yganyhlprnew	
	
est clear	
	
** live in nursing home
eststo: reg rnhmliv ${X}      ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean	
eststo: reg rnhmliv ${X} ${U} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean	
	
** use nursing home
eststo: reg rnrshom ${X}      ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean	
eststo: reg rnrshom ${X} ${U} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
	
** nursing home nights, among nursing home users
eststo: reg log_rnrsnit ${X}      ${CONTROLS} ${IF} & (rnrshom==1) & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg log_rnrsnit ${X} ${U} ${CONTROLS} ${IF} & (rnrshom==1) & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
	
esttab *, se compress starlevel(* .1 ** .05 *** .01) scalar(ymean) keep(children ${U})

local OPTS ///
  cells(b(fmt(a2) star) se(par fmt(a2))) ///
	compress starlevel(* .1 ** .05 *** .01) ///
	stats(N r2 ymean, label("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f)) ///
	${COEFLAB} ///
  nonum collab(none) ///
	mlab("(1)" "(2)" "(3)" "(4)" "(5)" "(6)", ///
       lhs("& \multicolumn{6}{c}{Dependent variables: nursing home utilization last 2 years} \\  \cline{2-7} & \multicolumn{2}{c}{NH resident} & \multicolumn{2}{c}{NH stay} & \multicolumn{2}{c}{Log(Nights)} \\ \cline{2-3} \cline{4-5} \cline{6-7} ")) ///
	nonotes nofloat ///
	substitute(main %main ///
	           \begin{tabular}{l*{6}{c}} \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
						 \end{tabular} \end{tabular*})
						 
** abbreviated table (TABLE K.1)
	
local FILENAME ///
  ${tabs}/TABK1.tex	
		
esttab * using `FILENAME', booktabs replace `OPTS' keep(${X} ${U})
cat `FILENAME'
	
** full table (TABLE K.2)

local OPTS ///
  wide ///
  b(a2) se(a2) ///
	compress starlevel(* .1 ** .05 *** .01) ///
	stats(N r2 ymean, label("Observations" "$ R^2 $" "Mean of dep. var.") ///
	  fmt(%9.0fc %3.2f %3.2f) ) ///
	${COEFLAB} ///
	order(${X} ${U}) ///
  nonum collab(none) ///
	mlab("(1)" "(2)" "(3)" "(4)" "(5)" "(6)", ///
       lhs("Dependent variable: & \multicolumn{4}{c}{Nursing home resident} & \multicolumn{4}{c}{Nursing home stay last two years} & \multicolumn{4}{c}{Log(Nights in nursing home)} \\ \cline{2-5} \cline{6-9} \cline{10-13} ")) ///
	nonotes nofloat ///
	substitute(main %main ///
	           \begin{tabular}{l*{6}{cc}} \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccccccccc} ///
						 \end{tabular} \end{tabular*})
	
local DROP ///
  drop(1.ragender 1.raracem 0.rahispan 0.hcpl 1.educ 0.radla 0.riadlza 1.cogfunction ///
	     1.hatotb10q5 1.hitot10q5 1.rcendiv *.w _cons)
	
local FILENAME ///
  ${tabs}/TABK2.tex	
		
esttab * using `FILENAME', booktabs replace `OPTS' `DROP'
cat `FILENAME'	
	
********************************************************************************
** APPENDIX TABLE K.3
********************************************************************************

** Children and nursing home utilization: Linear Specs., IV
	
* Three panels:
* A. NH resident
* B. NH stay
* C. Log(Nights)	
	
* Within each panel, X columns:
*	1. Baseline Spec.
* 2. Add endogenous regressor: child LTC helper
* 3. Add plausibly exogenous regressor: daughters
* 4. Add plausibly exogenous regressor: child within 10 miles
* 5. IV with daughters and distance
* 6. First stage: Endog X: child LTC helper. Z: daughters, child in 10 mi
	
global X ///
  children

global CONTROLS ///
  i.ragender i.raracem i.rahispan i.hcpl i.educ ///
  i.radla i.riadlza i.cogfunction ///
	ragey_b c.ragey_b#c.ragey_b ///
	i.hatotb10q5 i.hitot10q5 rownhm ///
	i.rcendiv ///
	i.w

global IF ///
  if (ragey_b >= 65 & ragey_b < .) & ((radla>=2 & radla<.) | inlist(cogfunction,2,3)) & (hcpl==0)
	
global WEIGHT ///
  [pw=rwtcrnh]	

global VCE ///
  vce(cluster hhidc)
	
global U ///
  yganyhlprnew	
	
global Z1 ///
  daughters
	
global Z2 ///
  child10mi

********** Y: live in nursing home	

global Y ///
  rnhmliv

est clear	

eststo: reg ${Y} ${X}            ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${U}       ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z1} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z2} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean

eststo: ivregress gmm ${Y} ${X} ${CONTROLS} (${U} = ${Z1} ${Z2}) ${IF} ${WEIGHT}, ${VCE}
estadd ysumm, mean
capture noisily estat overid, forceweights
estadd scalar pOverid = `=r(p_HansenJ)'	
estat endogenous, forceweights
estadd scalar pEndog = `=r(p_C)'
* first stage
eststo: reg ${U} ${Z1} ${Z2} ${X} ${CONTROLS} ${IF} & ~mi(${Y}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
test ${Z1} ${Z2}
estadd scalar Ftest = `=r(F)'	
	
* output	
esttab *, se compress starlevel(* .1 ** .05 *** .01) keep(${X} ${U} ${Z1} ${Z2}) ///
          stats(N r2 ymean N ymean pOverid pEndog Ftest)

local OPTS ///
  cells(b(fmt(a2) star) se(fmt(a2))) ///
	compress starlevel(* .1 ** .05 *** .01) ///
	stats(N ymean pOverid pEndog Ftest, ///
	  label("Observations" "Mean of dep. var." "\hline Over-ID: $ p $-value" "Exogeneity: $ p $-value" "$ F $-stat." ) ///
		fmt(%9.0fc %3.2f %3.2f %3.2f %3.2f)) ///
	${COEFLAB} ///
	keep(${X} ${U} ${Z1} ${Z2}) ///
  nonum collab(none) ///
	mlab("(WLS)" "(WLS)" "(WLS)" "(WLS)" "(IV)" "(WLS)", ///
       lhs("Dependent variable: & \multicolumn{5}{c}{Nursing home resident} & Child LTC helper \\  \cline{2-6} \cline{7-7} ")) ///
	nonotes nofloat nogaps ///
	substitute(main %main ///
	           \begin{tabular}{l*{6}{c}} \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
						 \end{tabular} \end{tabular*})
						 
* (TABLE K.3 PANEL (a))
	
local FILENAME ///
  ${tabs}/TABK3a.tex	
		
esttab * using `FILENAME', booktabs replace `OPTS' 
cat `FILENAME'
	
********** Y: use nursing home

global Y ///
  rnrshom

est clear	

eststo: reg ${Y} ${X}            ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${U}       ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z1} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z2} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean

eststo: ivregress gmm ${Y} ${X} ${CONTROLS} (${U} = ${Z1} ${Z2}) ${IF} ${WEIGHT}, ${VCE}
estadd ysumm, mean
capture noisily estat overid, forceweights
estadd scalar pOverid = `=r(p_HansenJ)'	
estat endogenous, forceweights
estadd scalar pEndog = `=r(p_C)'
* first stage
eststo: reg ${U} ${Z1} ${Z2} ${X} ${CONTROLS} ${IF} & ~mi(${Y}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
test ${Z1} ${Z2}
estadd scalar Ftest = `=r(F)'	
	
* output	
esttab *, se compress starlevel(* .1 ** .05 *** .01) keep(${X} ${U} ${Z1} ${Z2}) ///
          stats(N r2 ymean N ymean pOverid pEndog Ftest)

local OPTS ///
  cells(b(fmt(a2) star) se(fmt(a2))) ///
	compress starlevel(* .1 ** .05 *** .01) ///
	stats(N ymean pOverid pEndog Ftest, ///
	  label("Observations" "Mean of dep. var." "\hline Over-ID: $ p $-value" "Exogeneity: $ p $-value" "$ F $-stat." ) ///
		fmt(%9.0fc %3.2f %3.2f %3.2f %3.2f)) ///
	${COEFLAB} ///
	keep(${X} ${U} ${Z1} ${Z2}) ///
  nonum collab(none) ///
	mlab("(WLS)" "(WLS)" "(WLS)" "(WLS)" "(IV)" "(WLS)", ///
       lhs("Dependent variable: & \multicolumn{5}{c}{Nursing home stay last two years} & Child LTC helper \\  \cline{2-6} \cline{7-7} ")) ///
	nonotes nofloat nogaps ///
	substitute(main %main ///
	           \begin{tabular}{l*{6}{c}} \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
						 \end{tabular} \end{tabular*})
						 
* (TABLE K.3 PANEL (b))
	
local FILENAME ///
  ${tabs}/TABK3b.tex	
		
esttab * using `FILENAME', booktabs replace `OPTS' 
cat `FILENAME'	
	
********** Y: log nursing home nights

global Y ///
  log_rnrsnit

est clear	

eststo: reg ${Y} ${X}            ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X} ${U}       ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z1} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
eststo: reg ${Y} ${X}      ${Z2} ${CONTROLS} ${IF} & ~mi(${U}) ${WEIGHT}, ${VCE}
estadd ysumm, mean

eststo: ivregress gmm ${Y} ${X} ${CONTROLS} (${U} = ${Z1} ${Z2}) ${IF} ${WEIGHT}, ${VCE}
estadd ysumm, mean
capture noisily estat overid, forceweights
estadd scalar pOverid = `=r(p_HansenJ)'	
estat endogenous, forceweights
estadd scalar pEndog = `=r(p_C)'
* first stage
eststo: reg ${U} ${Z1} ${Z2} ${X} ${CONTROLS} ${IF} & ~mi(${Y}) ${WEIGHT}, ${VCE}
estadd ysumm, mean
test ${Z1} ${Z2}
estadd scalar Ftest = `=r(F)'	
	
* output	
esttab *, se compress starlevel(* .1 ** .05 *** .01) keep(${X} ${U} ${Z1} ${Z2}) ///
          stats(N r2 ymean N ymean pOverid pEndog Ftest)

local OPTS ///
  cells(b(fmt(a2) star) se(fmt(a2))) ///
	compress starlevel(* .1 ** .05 *** .01) ///
	stats(N ymean pOverid pEndog Ftest, ///
	  label("Observations" "Mean of dep. var." "\hline Over-ID: $ p $-value" "Exogeneity: $ p $-value" "$ F $-stat." ) ///
		fmt(%9.0fc %3.2f %3.2f %3.2f %3.2f)) ///
	${COEFLAB} ///
	keep(${X} ${U} ${Z1} ${Z2}) ///
  nonum collab(none) ///
	mlab("(WLS)" "(WLS)" "(WLS)" "(WLS)" "(IV)" "(WLS)", ///
       lhs("Dependent variable: & \multicolumn{5}{c}{Log(Nights in nursing home)} & Child LTC helper \\  \cline{2-6} \cline{7-7} ")) ///
	nonotes nofloat nogaps ///
	substitute(main %main ///
	           \begin{tabular}{l*{6}{c}} \begin{tabular*}{\textwidth}{@{\extracolsep{\fill}}lcccccc} ///
						 \end{tabular} \end{tabular*})
						 
* (TABLE K.3 PANEL (c))
	
local FILENAME ///
  ${tabs}/TABK3c.tex	
		
esttab * using `FILENAME', booktabs replace `OPTS' 
cat `FILENAME'		
	
********************************************************************************
