function out = utilde(e4,h,n,par)      
% Returns "indirect flow felicity" of spending e~ in last stage (only
% consumption for owners, consumption plus renting for renters) given
% housing state h and n persons per household in.
%
% Inputs:
% e4:       Array with stage-4 spending of household.
% h:        Array (conformable with e4) or scalar with housing state 
%           (equals h0for renters).
% n:        Array (conformable with e4) or scalar with household size.
% par:      Structure. Must contain parameters needed by functions Ash.m 
%           and thetah.m: g, r, xi, deltaHouse, h0, phi.
% 
% Output:   Array of same size as e4 with "indirect flow felicity" of
%           spending e4.

A     = Ash(n,h,par);           % Get marginal-utility shifter A(n,h).
theta = thetah(h,par);          % Get curvature of utility, ...
out   = A .* e4.^(1-theta) ./ (1-theta) ;  % ... then indirect felicity.
 