function out = ucinv(Va,f,nP,nHH,par) 
% Returns optimal consumption expenditure (or the inverse of marginal 
% utility) given the marginal value of saving Va = dV/da, for nP persons
% per household and for nHH households in the generation, and formal-care
% decision f:
% u_c^(-1) (V_a) = A(nP,nHH,f)^(1/g) * V_a^(-1/g),
% where A(.) is the marginal-utility shifter (see A.m and u.m)
% 
% Inputs (arrays of the same dimension or scalars):
% Va:                           Marginal utility of saving.
% f:                            Formal care (1), 0 for healthy and 
%                               informal-care and for kids.
% nP:                           Number of persons in household.
% nHH:                          Number of households.
% par:                          Structure, containing fields g and phi.
%
% Output:                       Array of same size as c.

g   = par.g;                    % Read out coefficient for power utility.
out = A(nP,nHH,f,par).^(1/g) .* Va.^(-1/g);
                                % Calculate inverse marginal utility.

