function out = uc(c,f,nP,nHH,par)       
% Returns marginal utility of consumption expenditure c for a generation
% with nP persons per households and nHH households:
% u_c(c,f,nP,nH) = A(nP,nHH,f) * c^(-g),
% where A(.) is the marginal-utility shifter (see A.m and u.m)
%
% Inputs (arrays of the same dimension or scalars):
% c:                            consumption
% f:                            formal care (1), 0 for healthy and 
%                               informal-care and for kids.
% nP:                           number of persons in household
% nHH:                          number of households.
% par:                          structure with fields g and phi
% 
% Output:                       Array of same size as c.

g   = par.g;                    % Read out coefficient for power utility
                                
if g==1                         % Log case: can neglect dividing by equiva-
    out = nP.*nHH.* c.^(-1);    % lence scale, just adds constant (see 
                                % function u.m).
else                            % For power-utility case:
    out = A(nP,nHH,f,par) .* c.^(-g);
end                             % See paper.
