function out = u(c,f,nP,nHH,par)      
% Returns flow utility for the generation of consuming c for nP persons per
% household and nHH households in the generation. 'par' is a structure
% containing the parameters of the utility function:
% u(c,f,nP,nHH) = A(nP,nHH,f) * c^(1-g)/(1-g),
% where A(.) is the marginal-utility shifter, see A.m.
%
% Inputs (arrays of the same dimension or scalars):
% c:                            Consumption expenditure for the entire
%                               generation.
% f:                            Formal care (1), 0 for healthy and 
%                               informal-care parents and for kids.
% nP:                           Number of persons in household.
% nHH:                          Number of households. 1 for parent
%                               generation, 1+nu for kid generation.
% par:                          Structure containing fields g and eta.
%
% Output:                       Array of same size as c.

g   = par.g;                    % Read out coefficient for power utility,
eta = par.eta;                  % and for disutility from formal care.
                                
if g == 1                       % For log case:
    out  = nP.*nHH.*log(c) - eta*f;
                                % Per-period utility of children (can leave
                                % out division by equivalence scale in log
                                % case since this just adds a constant).
else                            % For power-utility case:
    out = A(nP,nHH,f,par) .* c.^(1-g)/(1-g);
    %out  = nP.*nHH.*( exp(-eta*f).* c ./ (nHH.* phi(nP) ) ).^(1-g) / (1-g);
                                % c / (nHH*phi(nP) is equivalent
                                % consumption, multiply by total number of
end                             % persons to get flow utility.
